#! /usr/bin/perl

=head1 

    Если колбэк падает - мы повторяем запрос

=cut

use strict;
use warnings;

use Time::HiRes qw/time sleep/;
use Test::More;
use Test::HTTP::Server;
use utf8;

use Yandex::HTTP qw/http_parallel_request/;

my $resp;

# Запускаем тестовый http-сервер
my $server = Test::HTTP::Server->new();
sub Test::HTTP::Server::Request::test
{
    my $self = shift;
    return $self->{body};
}


sub _req {
    my ($fails, $body) = @_;
    return http_parallel_request(
        POST => {
            1 => {url => $server->uri."test", body => $body}
        }, 
        timeout => 1, 
        connect_timeout => 0.1,
        num_attempts => 2,
        callback => sub {
            if ($fails --> 0) { die; }
        }
        )->{1};
}

$resp = _req(0, 'everything should be ok');
ok($resp->{is_success});
ok(!exists $resp->{callback_error}, "no fails - good");

$resp = _req(1, 'everything should be ok');
ok($resp->{is_success});
ok(!exists $resp->{callback_error}, "one fail - retry works");

$resp = _req(2, 'everything callback error');
ok($resp->{is_success});
ok(exists $resp->{callback_error}, "two fails - equals to num_attempts - no chance");

done_testing();
