#! /usr/bin/perl

=head1 utf_post_body.t

    Тест проверяет что POST-запросы с utf8 body - работают.

=cut

use strict;
use warnings;

use Time::HiRes qw/time sleep/;
use Test::More;
use Test::HTTP::Server;
use utf8;

use Yandex::HTTP qw/http_parallel_request/;

my $resp;

# Запускаем тестовый http-сервер
my $server = Test::HTTP::Server->new();
sub Test::HTTP::Server::Request::test
{
    my $self = shift;
    return $self->{body};
}

sub _req {
    return http_parallel_request(POST => {1 => {url => $server->uri."test", body => shift}}, timeout => 1, connect_timeout => 0.1)->{1};
}

$resp = _req('everything should be ok');
ok($resp->{is_success}, "success request without unicode data");
is($resp->{content}, "everything should be ok", "correct response content");

$resp = _req('запрос содержит юникодные символы  #End');
ok($resp->{is_success}, "success request with unicode data");
like($resp->{content}, qr/#End$/, "correct response content");

done_testing();
