use strict;
use warnings;

use Test::Deep qw/cmp_deeply/;
use Test::More;
use Yandex::MailTemplate;

my @tests = (
    [
        "aaa\naaa\n\nbbb\n\nccc",
        [
            {type => 'text', content => "aaa\naaa"},
            {type => 'whitespace', content => ""},
            {type => 'text', content => "bbb"},
            {type => 'whitespace', content => ""},
            {type => 'text', content => "ccc"},
        ],
        'simple paragraphs'
    ],
    [
        "aaa\nbb[% b\n\nc %]cc",
        [
            {type => 'text', content => "aaa\nbb[% b\n\nc %]cc"},
        ],
        'tt directive with line break'
    ],
    [
        "aaa\nbbb\n\nccc\n\n\n",
        [
            {type => 'text', content => "aaa\nbbb"},
            {type => 'whitespace', content => ""},
            {type => 'text', content => "ccc"},
            {type => 'whitespace', content => "\n\n"},
        ],
        'trailing empty lines'
    ],
    [
        "\n\naaa\nbbb\n\nccc",
        [
            {type => 'whitespace', content => "\n"},
            {type => 'text', content => "aaa\nbbb"},
            {type => 'whitespace', content => ""},
            {type => 'text', content => "ccc"},
        ],
        'leading empty lines'
    ],
);
cmp_deeply (Yandex::MailTemplate::get_email_template_paragraphs($_->[0]), $_->[1], $_->[2]) for @tests;
done_testing;
