#!/usr/bin/perl -w

use strict;
use warnings;

use Test::More;
use Test::Exception;

use Yandex::I18n;

%Yandex::I18n::LANG_ALIAS = ( ua => 'uk' );
$Yandex::I18n::LOCALE_PATH = '/dev/null';

sub cr { Yandex::I18n::current_lang @_ }
sub init { Yandex::I18n::init_i18n @_ }

init('tr');
is cr(), 'tr', 'non-aliased lang';

init('ua');
is cr(), 'uk', 'aliased lang';

init('zz');
is cr(), $Yandex::I18n::DEFAULT_LANG, 'unknown lang';

dies_ok {init('ua', check_file => 1)} 'exception on known lang without translation file';
lives_ok {init($Yandex::I18n::DEFAULT_LANG, check_file => 1)} 'no exception on default lang';


done_testing();

