#!/usr/bin/perl 

use warnings;
use strict;

use Yandex::Test::UTF8Builder;
use Test::More;

use Yandex::I18n;

use utf8;

my @test_cases = (
#    [
#        'исходный текст',
#        'переведённый текст',
#        {параметры},
#        'текст, который должен получиться',
#    ],

    # подставляем текст с заменой имени параметра на текст
    [
        'Пожалуйста, %{on#активируйте} таймер самоуничтожения',
        'Please, %{on#activate} the self-destruct timer',
        {on => '<a href="/doom_timer">$on$</a>'},
        'Please, <a href="/doom_timer">activate</a> the self-destruct timer',
    ],
    # пробелы в имени параметра игнорируем, а в заменяющем тексте -- нет
    [
        'Пожалуйста, %{on#активируйте } таймер самоуничтожения',
        'Please, %{  on #  activate } the self-destruct timer',
        {on => '<a href="/doom_timer">$on$</a>'},
        'Please, <a href="/doom_timer">  activate </a> the self-destruct timer',
    ],
    # заменяющий текст не обязателен
    [
        'Пожалуйста, %{on#} таймер %{selfdestruct}',
        'Please, %{on#} the %{selfdestruct} timer',
        {on => '<a href="/doom_timer">activate</a>', selfdestruct => sub { my($text, $name) = @_; return 'self-destruct'; }},
        'Please, <a href="/doom_timer">activate</a> the self-destruct timer',
    ],
    # подставляем несколько текстов на место параметров
    [
        'Пожалуйста, %{on#активируйте} таймер %{selfdestruct#самоуничтожения}',
        'Please, %{on#activate} the %{selfdestruct#self-destruct} timer',
        {on => '<a href="/doom_timer">$on$</a>', selfdestruct => '<strong>$selfdestruct$</strong>'},
        'Please, <a href="/doom_timer">activate</a> the <strong>self-destruct</strong> timer',
    ],
    # подставляем результаты функций на место параметров
    [
        'Пожалуйста, %{on#активируйте} таймер %{selfdestruct#самоуничтожения}',
        'Please, %{on#activate} the %{selfdestruct#self-destruct} timer',
        {
            on => sub { my ($text, $name) = @_; return qq!<a href="/doom_timer">$text</a>!; },
            selfdestruct => sub { my ($text, $name) = @_; return qq!<strong>$text</strong>!; },
        },
        'Please, <a href="/doom_timer">activate</a> the <strong>self-destruct</strong> timer',
    ],
    [
        'тест без параметров',
        'test without parameters',
        undef,
        'test without parameters',
    ],
);

Test::More::plan(tests => scalar(@test_cases));

for my $case (@test_cases) {
    my ($source_text, $translated_text, $params, $expected_text) = @$case;
    no warnings 'redefine';
    local *Yandex::I18n::iget = sub {return $translated_text};
    my $got_text = piget($source_text, $params);
    is($got_text, $expected_text, $source_text);
}
