#!/usr/bin/perl 

use warnings;
use strict;

use Yandex::Test::UTF8Builder;
use Test::More;
use Test::Deep;

use Yandex::I18n;

use utf8;

my @test_cases = (
#    [
#        'исходный текст',
#        'переведённый текст',
#        {параметры},
#        [qw/ожидаемый результат/],
#    ],

    # подставляем объект на место параметра
    [
        'Пожалуйста, %{on#активируйте} таймер самоуничтожения',
        'Please, %{on#activate} the self-destruct timer',
        {on => {cool_object => 1}},
        ['Please, ', {cool_object => 1}, ' the self-destruct timer'],
    ],
    # подставляем два объекта на место параметров
    [
        'Пожалуйста, %{on#активируйте} таймер %{selfdestruct#самоуничтожения}',
        'Please, %{on#activate} the %{selfdestruct#self-destruct} timer',
        {on => {cool_object => 1}, selfdestruct => {cool_object => 2}},
        ['Please, ', {cool_object => 1}, ' the ', {cool_object => 2}, ' timer'],
    ],
    # подставляем объект, возвращённый из фукнции, на место параметра
    [
        'Пожалуйста, %{on#активируйте} таймер самоуничтожения',
        'Please, %{  on #  activate } the self-destruct timer',
        {on => sub { my ($text, $name) = @_; return {cool_object => 1, text => $text}; }},
        ['Please, ', {text => '  activate ', cool_object => 1}, ' the self-destruct timer'],
    ],
    # подставляем две строки как результаты функций
    [
        'Пожалуйста, %{on#активируйте} таймер %{selfdestruct#самоуничтожения}',
        'Please, %{on#activate} the %{selfdestruct#self-destruct} timer',
        {on => sub { my ($text, $name) = @_; return "1$name: $text"; }, selfdestruct => sub { my($text, $name) = @_; return "2$name: $text"; }},
        ['Please, ', '1on: activate', ' the ', '2selfdestruct: self-destruct', ' timer'],
    ],
    [
        'тест без параметров',
        'test without parameters',
        undef,
        ['test without parameters'],
    ],
);

Test::More::plan(tests => scalar(@test_cases));

for my $case (@test_cases) {
    my ($source_text, $translated_text, $params, $expected_array) = @$case;
    no warnings 'redefine';
    local *Yandex::I18n::iget = sub {return $translated_text};
    my $got_array = piget_array($source_text, $params);
    cmp_deeply($got_array, $expected_array, $source_text);
}
