#!/usr/bin/perl -w

=pod
    $Id$
    проверка работы с национальными доменами
=cut

use strict;

use Test::More tests => 12;
use Yandex::IDN;

use utf8;
use open ':std' => ':utf8';

*ia = \&Yandex::IDN::idn_to_ascii;

is(ia("www.ya.ru"), "www.ya.ru");
is(ia("https://www.ya.ru"), "https://www.ya.ru");
is(ia("www.ya.ru#asdasd"), "www.ya.ru#asdasd");
is(ia("http://www.ya.ru:80"), "http://www.ya.ru:80");
is(ia("москва.ru"), "xn--80adxhks.ru");
is(ia("http://киев.ua:8080/asdf?asd=фыв"), "http://xn--b1afih.ua:8080/asdf?asd=фыв");
is(ia("http://www.киев.ua:8080/asdf?asd=".("фыв" x 100)), "http://www.xn--b1afih.ua:8080/asdf?asd=".("фыв" x 100));
is(ia("www.киев.ua#".("фыв" x 100)), "www.xn--b1afih.ua#".("фыв" x 100));
is(ia(undef), '');

is(ia('HtTp://med-serdce.ru/'), 'HtTp://med-serdce.ru/');
is(ia('http://profit_up.all4retail.ru/'), 'http://profit_up.all4retail.ru/');

is(ia("\nhttps://direct.yandex.ru\n"), "\nhttps://direct.yandex.ru\n");
