#!/usr/bin/perl -w

=pod
    $Id$
    проверка работы с национальными доменами
=cut

use strict;

use Test::More tests => 11;
use Yandex::Test::UTF8Builder;
use Yandex::IDN;

use utf8;
use open ':std' => ':utf8';

*iu = \&Yandex::IDN::idn_to_unicode;

is(iu("www.ya.ru"), "www.ya.ru");
is(iu("https://www.ya.ru"), "https://www.ya.ru");
is(iu("www.ya.ru#asdasd"), "www.ya.ru#asdasd");
is(iu("http://www.ya.ru:80"), "http://www.ya.ru:80");
is(iu("xn--80adxhks.ru"), "москва.ru");
is(iu("http://xn--b1afih.ua:8080/asdf?asd=фыв"), "http://киев.ua:8080/asdf?asd=фыв");
is(iu("http://www.xn--b1afih.ua:8080/asdf?asd=".("фыв" x 100)), "http://www.киев.ua:8080/asdf?asd=".("фыв" x 100));
is(iu("www.xn--b1afih.ua#".("фыв" x 100)), "www.киев.ua#".("фыв" x 100));
is(iu(undef), '');
is(iu('XN--80AJAB1AH4AGDG.SU'),iu(lc('XN--80AJAB1AH4AGDG.SU')),'разный регистр');

is(iu("\nhttps://direct.yandex.ru\n"), "\nhttps://direct.yandex.ru\n");
