#!/usr/bin/perl -w

# $Id$

use strict;
use Test::More;

BEGIN { use_ok( 'Yandex::IDN', qw(is_valid_domain) ); }

use utf8;
use open ':std' => ':utf8';

*vd = \&is_valid_domain;

ok(vd('yandex-team.ru'));
ok(vd('ya.museum'));
ok(vd('www.yandex-team.ru'));
ok(vd('w9879-23ww.yandex-team.ru'));
ok(vd('MAIL.RU'));
ok(vd('  gmail.com'));
ok(vd('gmail.com  '));
ok(vd("\t \r\ngmail.com\t"));
ok(vd('profit_up.all4retail.ru'));

ok(!vd('yandex-team.ru.'));
ok(!vd('yandex-team'));
# о горе нам, мы такое не ловим. Но при пинге сервера все равно ругнемся.
ok(vd('mail-.ru'));
ok(!vd('mail.ru@'));
ok(!vd('ma@il.ru'));

# русское безобразие
ok(vd('кремль.рф'));
ok(vd('впрезиденты.ru'));
ok(vd('www.яндекс.рф'));
ok(vd('ввв.яндекс.рф'));
ok(vd('xn--d1acpjx3f.xn--p1ai'));
ok(vd('xn--d1acpjx3f.рф'));
ok(vd('xn--d1acpjx3f.ru'));
ok(vd('yandex.рф'));
ok(vd('чай.кофе.потанцуем'));
ok(vd('экспрессденьги.онлайн'));
# кириллические имена не разрешены, и в таком виде на самом деле скорее всего тоже
# но у нас не супер-мега точная проверка
ok(vd('xn--d1acpjx3f.xn--p1ai'));
ok(vd('моё-железо.рф'));

ok(vd('www.ru'));

# проверки на максимальную длину поддомена (63 символа)
ok( vd('a123456789-123456789-123456789-123456789-123456789-123456789123.ru'));
ok(!vd('a123456789-123456789-123456789-123456789-123456789-1234567891234.ru'));
ok(!vd('a123456789-123456789-123456789-123456789-123456789-123456789123.qweasdzxcrqweasdzxcrqweasdzxcrqweasdzxcrqweasdzxcrqweasdzxcrooo'));
ok(vd('a123456789-123456789-123456789-123456789-123456789-123456789123.a12345678912345')); # TLD - 15 chars
ok(!vd('a123456789-123456789-123456789-123456789-123456789-123456789123.a123456789123456')); # TLD - 16 chars
ok(!vd('a123456789-123456789-123456789-123456789-123456789-123456789123.a')); # TLD - 1 chars

ok( vd('a123456789-123456789-123456789-123456789-123456789-123456789123.a123456789-123456789-123456789-123456789-123456789-123456789123.ru'));
ok(!vd('a123456789-123456789-123456789-123456789-123456789-123456789123.a123456789-123456789-123456789-123456789-123456789-1234567891234.ru'));

ok( vd('a123456789-123456789-123456789-123456789-123456789-123456789123.рф'));
ok(!vd('a123456789-123456789-123456789-123456789-123456789-1234567891234.рф'));

ok( vd('xn--bfejrhfbjhfjhbrjfhberufbuhbuerbureberubfeurbfeurfberubfuerf.xn--p1ai'));
ok(!vd('xn--bfejrhfbjhfjhbrjfhberufbuhbuerbureberubfeurbfeurfberubfuerfs.xn--p1ai'));

ok( vd('a123456789-123456789-123456789-123456789-123456789-123456789123.a123456789-123456789-123456789-123456789-123456789-123456789123.рф'));
ok(!vd('a123456789-123456789-123456789-123456789-123456789-123456789123.a123456789-123456789-123456789-123456789-123456789-1234567891234.рф'));

ok(vd("\x{456}.ua"), "cyrillic i in domain name");
ok(!vd("m\x{456}crosoft.com"), "cyrillic i in domain name mixed with latin chars");
ok(vd("www.xn----8sbahjdvhbonot5a2a02a.kiev.ua"));

ok(vd("\x{4E9}.kz"));

ok(vd("atatürk.tr"));
ok(!vd("domain.123"));
ok(vd("123.domain"));
ok(vd("123.a123"));

# проверка странных случаев с национальными поддоменами. валидность с точки зрения теста
# здесь задана эмпирически (по возможности преобразовать домен в punycode)
ok(!vd("фотосъемка-презентация--портретная--репортажная.f2biz.ru"));
ok(vd("фотосъемка-презентация-портретная-репортажная.f2biz.ru"));
ok(vd("фотосъемка-презентация--портретнав--репортажнам.f2biz.ru"));
ok(!vd("кроватки-для-малышей-интернет-магазин-с-доставкой.ikea.dostavka5.ru"));
ok(!vd("доставка-товаров-по-россии-для-интернет-магазинов.12з.рф"));

done_testing();
