#!/usr/bin/perl -w

# $Id$

use strict;
use Test::More;

BEGIN { use_ok( 'Yandex::IDN', qw(is_valid_email) ); }

use utf8;
use open ':std' => ':utf8';

*ve = \&is_valid_email;

ok(ve('zhur@yandex-team.ru'));
ok(ve('zhur@ya.museum'));
ok(ve('zhur@www.yandex-team.ru'));
ok(ve('zh.qewr-rqwur@w9879-23ww.yandex-team.ru'));
ok(!ve('zhur@ yandex-team.ru'));
ok(!ve('zhur@yandex-team.ru.'));
ok(!ve('zhur@yandex-team'));
ok(!ve('zhur.yandex-team.ru'));
ok(!ve('ывап@yandex-team'));
ok(!ve('den..k@mail.ru'));
ok(!ve('.den.k@mail.ru'));
ok(!ve('den.k.@mail.ru'));
ok(!ve('den@-mail.ru'));
ok(ve('den@mail-.ru'));
ok(!ve('den@@mail.ru'));
ok(!ve('den@mail.ru@'));
ok(!ve('den@ma@il.ru@'));
ok(!ve('"John @ Doe"@mail.ru'));
ok(ve('@',('check_only_at_symbol' => 1)));
ok(ve('имя@домен.ру',('check_only_at_symbol' => 1)));
ok(ve('name@domain.ru',('check_only_at_symbol' => 1)));
ok(ve('@домен',('check_only_at_symbol' => 1)));
ok(ve('имя@',('check_only_at_symbol' => 1)));
ok(!ve('домен',('check_only_at_symbol' => 1)));
ok(!ve('domain',('check_only_at_symbol' => 1)));

# русское безобразие
ok(ve('skaurus@кремль.рф'));
ok(ve('skaurus@впрезиденты.ru'));
ok(ve('skaurus@www.яндекс.рф'));
ok(ve('skaurus@ввв.яндекс.рф'));
ok(ve('skaurus@xn--d1acpjx3f.xn--p1ai'));
ok(ve('skaurus@xn--d1acpjx3f.рф'));
ok(ve('skaurus@xn--d1acpjx3f.ru'));
ok(ve('skaurus@yandex.рф'));
ok(ve('skaurus@чай.кофе.потанцуем'));
ok(ve('msa@экспрессденьги.онлайн'));
ok(!ve('димон@яндекс.рф'));
# кириллические имена не разрешены, и в таком виде на самом деле скорее всего тоже
# но у нас не супер-мега точная проверка
ok(ve('xn--d1aimee@xn--d1acpjx3f.xn--p1ai'));

ok(ve('nataliya_vladimi@MAIL.RU'));
ok(ve('HTC-eclick@yandex.ru'));
ok(ve('BICZUR28@YANDEX.RU'));

ok(ve('  skaurus@gmail.com'));
ok(ve('skaurus@gmail.com  '));
ok(ve("\t \r\nskaurus\@gmail.com\t"));

ok(ve('shithappens@моё-железо.рф'));

done_testing();
