#!/usr/bin/perl -w

=pod
	$Id$
=cut

use strict;

use Test::More tests => 10;
use Test::Exception;

use Yandex::Interpolate;

use utf8;

*cc = \&Yandex::Interpolate::interpolate_const;

my @LIMITS = ({x=>1,y=>1}, {x=>10,y=>10}, {x=>100,y=>100});

is(cc(1, @LIMITS), 1, "seg 1-1");
is(cc(5, @LIMITS), 1, "seg 1-2");
is(cc(15, @LIMITS), 10, "seg 2-1");
is(cc(99, @LIMITS), 10, "seg 2-2");
is(cc(101, @LIMITS), 100, "seg 3-1");

is(cc(-10, @LIMITS), 1, "seg 1-0");
is(cc(0, @LIMITS), 1, "x = 0");

my @LIMITS2 = ({x=>1,y=>1});

is(cc(-10, @LIMITS2), 1, "1 seg - 1");
is(cc(10, @LIMITS2), 1, "1 seg - 2");

dies_ok {cc(5)} "no set segments";
