#!/usr/bin/perl -w

=pod
	$Id$
=cut

use strict;

use Test::More tests => 10;
use Test::Exception;

use Yandex::Interpolate;

use utf8;

*cc = sub { return int Yandex::Interpolate::interpolate_linear(@_) };

my @LIMITS = ({x=>1,y=>1}, {x=>10,y=>10}, {x=>100,y=>200});

is(cc(1, @LIMITS), 1, "seg 1-1");
is(cc(5, @LIMITS), 5, "seg 1-2");
is(cc(55, @LIMITS), 105, "seg 2-1");
is(cc(90, @LIMITS), 178, "seg 2-2");
is(cc(101, @LIMITS), 200, "seg 3-1");

is(cc(-10, @LIMITS), 1, "seg 1-0");
is(cc(0, @LIMITS), 1, "x = 0");

my @LIMITS2 = ({x=>1,y=>1});

is(cc(-10, @LIMITS2), 1, "1 seg - 1");
is(cc(10, @LIMITS2), 1, "1 seg - 2");

dies_ok {cc(5)} "no set segments";
