#!/usr/bin/perl -w

use strict;
use Test::More tests => 4;
use Test::Deep;

use Yandex::Interpolate qw/resample/;

use Carp ();
$SIG{__WARN__} = \&Carp::cluck;

my @a = ([2, "a"], [1, "b"], [11, "b"]);

cmp_deeply(resample([map {{x=>$_, y=>1}} 1..4]), [map {{x=>$_, y=>1}} 1, 4]);
cmp_deeply(resample([map {{x=>$_, y=>1 + (($_ >1 and $_ < 7) ? rand(0.05) : 0) }} 1..7], {absolute_gap => 0.05} ), [map {{x=>$_, y=>1}} 1, 7]);

my $data = [map {{x=>$_, y=> sin ($_*3.14159 + 1) }} 1..10];
cmp_deeply(resample($data,{absolute_gap => 0.005}), $data);
cmp_deeply(resample(
        [
            {x => 1, y => 0},
            {x => 2, y => 0},
            {x => 3, y => 0},
            {x => 4, y => 0},
            {x => 5, y => 0},
            {x => 6, y => 1},
            {x => 7, y => 0},
            {x => 8, y => 0},
            {x => 9, y => 0},
        ]),
        [
            {x => 1, y => 0},
            {x => 5, y => 0},
            {x => 6, y => 1},
            {x => 7, y => 0},
            {x => 9, y => 0},
        ]
    )
