package Yandex::Jabber;

use strict;
use warnings;

use AE;
use AnyEvent::XMPP::Client;
use Yandex::HashUtils qw/hash_cut/;
use ProjectSpecific qw/get_jabber_connection_settings/;

use base qw/Exporter/;
our @EXPORT = qw/
    send_jabber_message
/;

use utf8;

=head2 send_jabber_message

    Отправляет сообщение в джаббер указанным пользователям.
    Использует настройки из ProjectSpecific.

    Принимает именованные параметры:
        to -- адресат сообщения или ссылка на массив адресатов [обязательный]
              значения должны быть валдными JIDами (т.е. 'pankovpv@yandex-team.ru' или 'pankovpv@yandex-team.ru/WORK')
        message -- текст отправляемого сообщения [обязательный]
        type -- тип сообщния [необязательный], подробности см. в AnyEvent::XMPP::Client, по умолчению 'chat'

=cut

sub send_jabber_message
{
    my (%O) = @_;
    $O{type} = "chat" unless exists $O{type};

    die 'no recepients specified' unless $O{to};
    die 'no message text given' unless $O{message};
    my $recipients = ref($O{to}) eq 'ARRAY' ? $O{to} : [$O{to}];
    die 'no recepients specified' unless @$recipients;

    my $config = get_jabber_connection_settings();
    my $sent = 0;
    my $cv = AE::cv;

    my $cl = new AnyEvent::XMPP::Client(debug => 0);
    $cl->add_account(
        $config->{username}.'@'.$config->{componentname}, 
        $config->{password}, 
        $config->{xmpp_server_hostname},
        $config->{xmpp_server_port}, 
        { connect_timeout => 10, resource => 'Yandex::Jabber' } 
    );

    $cl->reg_cb(
        session_ready => sub {
            my ($cl) = @_;
            for my $dest (@$recipients) {
                $cl->send_message($O{message}, $dest, $cl->get_connected_accounts(), $O{type});
            }
            $sent = 1;
        },
        send_buffer_empty => sub {
            if ($sent) {
                $cl->disconnect();
            }
        },
        error => sub {
            my ($con, $error) = @_;
            print STDERR "Error: " . $error->string . "\n";
            $cv->send(0);
        },
        disconnect => sub {
            my ($con, $h, $p, $reason) = @_;
            $cv->send(1);
        }
    );
    $cl->start;
    $cv->recv;
}

1;
