#!/usr/bin/perl -w

=pod
    Проверка реализации бинарного поиска в Yandex::Ketama
=cut

use strict;
use Test::More tests => 16;

use Yandex::Ketama;

my @arr = (2, 3, 7, 100);
sub f {
    return Yandex::Ketama::_find_idx(\@arr, @_);
}
ok(f(0) == 0);
ok(f(1) == 0);
ok(f(2) == 0);
ok(f(3) == 1);
ok(f(4) == 2);
ok(f(5) == 2);
ok(f(7) == 2);
ok(f(9) == 3);
ok(f(90) == 3);
ok(f(100) == 3);
ok(f(101) == 0);

my @arr2 = (0..10000);
sub f2 {
    return Yandex::Ketama::_find_idx(\@arr2, @_);
}
ok(f2(0) == 0);
ok(f2(100000) == 0);
ok(f2(10) == 10);
ok(f2(103) == 103);
ok(f2(1223) == 1223);
