#!/usr/bin/perl -w

=pod
    Проверка распределений, выдаваемых Yandex::Ketama
=cut

use strict;
use List::Util qw/sum/;
use Test::More;
use Data::Dumper;

use Yandex::Ketama;

my $SNUM = 10;
my $TESTS = 10_000;

for my $points (1000, undef) {
    for my $snum (1..$SNUM) {
        my $k = new Yandex::Ketama(points => $points, servers => [map {{name => $_, weight => 1/($_+1)}} 0..$snum-1]);
        
        # делаем вбросы
        my (%DIST, %SUM);
        for my $p (1..$TESTS) {
            my $s = $k->find("dfasd${p}asdfads");
            $DIST{$s}++;
            $SUM{$s}++;
            while(defined ($s = $k->next())) {
                $SUM{$s}++;
            }
        }
        
        # проверка распределения
        my @weights = map {1/($_+1)} 0..$snum-1;
        my $weights_sum = sum @weights;
        for my $s (0..$snum-1) {
            my $ideal = $TESTS * $weights[$s] / $weights_sum;
            my $low = $ideal * 0.8;
            my $high = $ideal * 1.2;
            ok($DIST{$s} > $low && $DIST{$s} < $high, "dist $s/$snum: $low < $DIST{$s} < $high");
            ok($SUM{$s} == $TESTS, "sum $s/$snum: $SUM{$s} == $TESTS");
        }
    }
}

my $k = new Yandex::Ketama(servers => [{name => 0, weight => 0}, {name => 1, weight => 5e6}, {name => 2, weight => 5e6}]);
# делаем вбросы
my @STAT;
for my $p (1..$TESTS) {
    my @ret = $k->find_all("dfasd${p}asdfads");
    for my $i (0..$#ret) {
        $STAT[$i]{$ret[$i]}++;
    }
}
is($STAT[2]{0}, $TESTS, "find_all - zero weight");
for (1,2) {
    ok($STAT[0]{$_} > 0.8*$TESTS/2 && $STAT[0]{$_} < 1.2*$TESTS/2, "find_all - $_");
}


done_testing;
