package Yandex::LiveFile::JSON;

=head1 NAME

    Yandex::LiveFile::JSON - данные из JSON-файла с автоматическим обновлением

=head1 DESCRIPTION

    Аналогично Yandex::LiveFile, но дополнительно содержимое файла парсится как json
    и предоставляется доступ к данным

=head1 SYNOPSIS

    my $f = Yandex::LiveFile::JSON->new(filename => "test.json");
    print Dumper $f->data;
    print $f->data->{root}->{array}->[15];

=cut

use strict;
use warnings;

use JSON;

use base qw/Yandex::LiveFile/;

sub data {
    my ($self) = (shift);
    if (!defined $self->{_json_data} || $self->refresh()) {
        $self->{_json_data} = undef;
        $self->{_json_data} = JSON::from_json($self->SUPER::data());
    }
    return $self->{_json_data};
}

1;
