package Yandex::LiveFile::YAML;

=head1 NAME

    Yandex::LiveFile::YAML - данные из YAML-файла с автоматическим обновлением

=head1 DESCRIPTION

    Аналогично Yandex::LiveFile, но дополнительно содержимое файла парсится как yaml
    и предоставляется доступ к данным

=head1 SYNOPSIS

    my $f = Yandex::LiveFile::YAML->new(filename => "test.yaml");
    print Dumper $f->data;
    print $f->data->{root}->{array}->[15];

=cut

use strict;
use warnings;

use YAML;

use base qw/Yandex::LiveFile/;

sub data {
    my ($self) = (shift);
    if (!defined $self->{_yaml_data} || $self->refresh()) {
        $self->{_yaml_data} = undef;
        $self->{_yaml_data} = YAML::Load($self->SUPER::data());
    }
    return $self->{_yaml_data};
}

1;
