#!/usr/bin/perl -w

use strict;
use File::Temp qw/tempfile/;
use File::Slurp;
use Test::Exception;
use Test::MockTime qw/:all/;
use Test::Deep;
use JSON;

use Test::More tests => 5;

use Yandex::LiveFile::JSON;

my (undef, $file) = tempfile(UNLINK => 1);

set_fixed_time('01/01/2001 03:00:00', '%m/%d/%Y %H:%M:%S');

write_file($file, {atomic => 1}, JSON::to_json({test => 1, root => {arr => [1,2,3]}}));
my $ff = Yandex::LiveFile::JSON->new(filename => $file);

is($ff->data->{test}, 1);
is_deeply($ff->data, {test => 1, root => {arr => [1,2,3]}});
is($ff->data->{root}->{arr}->[1], 2);

write_file($file, {atomic => 1}, "test2");
set_fixed_time('01/01/2001 03:00:01', '%m/%d/%Y %H:%M:%S');
dies_ok {$ff->data};

write_file($file, {atomic => 1}, '[]');
set_fixed_time('01/01/2001 03:00:03', '%m/%d/%Y %H:%M:%S');
is_deeply($ff->data, []);
