#!/usr/bin/perl -w

use strict;
use File::Temp qw/tempfile/;
use File::Slurp;
use Test::MockTime qw/:all/;
use Test::Exception;

use Test::More tests => 6;

use Yandex::LiveFile;

set_fixed_time('01/01/2001 03:00:00', '%m/%d/%Y %H:%M:%S');

my (undef, $file) = tempfile(UNLINK => 1);

write_file($file, "test1");
my $ff = Yandex::LiveFile->new(filename => $file);

is($ff->data, "test1", "initial read");
write_file($file, {atomic => 1}, "test2");
is($ff->data, "test1", "don't check file twice in a second");

set_fixed_time('01/01/2001 03:00:02', '%m/%d/%Y %H:%M:%S');
is($ff->data, "test2", "file content updated (by inode)");

write_file($file, "test22");
set_fixed_time('01/01/2001 03:00:04', '%m/%d/%Y %H:%M:%S');
is($ff->data, "test22", "file content updated (by size)");

set_fixed_time('01/01/2001 03:00:06', '%m/%d/%Y %H:%M:%S');
write_file($file, "test\n33");
utime time, time+10, $file;
is($ff->data, "test\n33", "file content updated (by mtime)");

set_fixed_time('01/01/2001 03:00:08', '%m/%d/%Y %H:%M:%S');
unlink $file;
dies_ok {$ff->data};
