#!/usr/bin/perl -w

=head1 

Тест фиксирует поведение Y::LiveFile для несуществующих файлов:

  * Объект LiveFile можно создать даже если файла пока нет; 
  * когда файл появится -- его содержимое станет доступно;
  * попытка получить данные из несуществующего файла -- die.

=cut

use strict;
use warnings;

use Test::More;
use Test::Exception;
use Test::MockTime qw/:all/;

use File::Temp qw/tempfile tempdir/;
use Path::Tiny;

use Yandex::LiveFile;

set_fixed_time('01/01/2001 03:00:00', '%m/%d/%Y %H:%M:%S');

my $dir = tempdir( CLEANUP => 1 );

my $file = "$dir/file_01";

my $ff;

# Объект LiveFile можно создать даже если файла пока нет;
lives_ok { $ff = Yandex::LiveFile->new(filename => $file); } "creating LiveFile object for non-existent file";

# попытка получить данные из несуществующего файла -- die.
dies_ok { $ff->data } "non-existent file has no data, should die";

path($file)->spew( 'test1' );

# когда файл появится -- его содержимое станет доступно
lives_and { is $ff->data, 'test1' } 'existent file has data';

done_testing();

