#!/usr/bin/perl -w

=head1 

    Тест проверяет, что можно взять ссылку на данные из LiveFile, и она (ссылка) продолжит указывать на те же данные даже после обновления файла.

=cut

use strict;
use Test::More;
use File::Temp qw/tempfile/;
use File::Slurp;
use Test::Exception;
use Test::MockTime qw/:all/;
use Test::Deep;
use YAML;

use Yandex::LiveFile::YAML;

my (undef, $file) = tempfile(UNLINK => 1);

set_fixed_time('01/01/2001 03:00:00', '%m/%d/%Y %H:%M:%S');

write_file($file, {atomic => 1}, YAML::Dump({test => 1, root => {arr => [1,2,3]}}));
my $ff = Yandex::LiveFile::YAML->new(filename => $file);

my $data_1 = $ff->data;

# ожидаемые значения
is($data_1->{test}, 1);
is_deeply($data_1, {test => 1, root => {arr => [1,2,3]}});
is($data_1->{root}->{arr}->[1], 2);

set_fixed_time('01/01/2001 03:00:01', '%m/%d/%Y %H:%M:%S');

write_file($file, {atomic => 1}, YAML::Dump({test => 2, root => {arr => [11,12,13]}}));

my $data_2 = $ff->data;

# в старых данных -- старые значения
is($data_1->{test}, 1);
is_deeply($data_1, {test => 1, root => {arr => [1,2,3]}});
is($data_1->{root}->{arr}->[1], 2);

# в новых данных -- новые
is($data_2->{test}, 2);
is_deeply($data_2, {test => 2, root => {arr => [11,12,13]}});
is($data_2->{root}->{arr}->[1], 12);

done_testing();

