#!/usr/bin/perl

use 5.010;
use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../lib";
use Yandex::Log;
use Yandex::Profile;

use Benchmark;

$Yandex::Log::USE_SYSLOG = 1;
$Yandex::Log::LOG_ROOT = "./";

Yandex::Profile::init();
my $t = script_timer(benchmark => 'benchmark');
my $t1 = Benchmark->new;
for (1 .. 100000) {
    my $log = Yandex::Log->new(
        log_file_name => "benchmark.log",
    );
    $log->out("X" x $_);
}
my $t2 = Benchmark->new;
my $td = timediff($t2, $t1);
say timestr($td);
