#!/usr/bin/perl

use common::sense;
use Path::Tiny;
use lib::abs '../lib';
use Yandex::Log;
use List::MoreUtils qw/uniq/;
use Time::HiRes qw/time/;

=head1 DESCRIPTION

небольшой скрипт для проверки того, как работает параллельная запись в лог без блокировки
при открытии файла с O_APPEND, как это делает open(..., '>>'), запись в файл происходит
атомарно, однако перловый print буферизирует запись, и из-за этого возможна каша из
строк - атомарности при записи кусков буфера не будет
решение - делать syswrite, он работает с file handle напрямую, без буферизации

=cut

my $tmpdir = Path::Tiny->tempdir('yandex_log_XXXXXXXX');

$Yandex::Log::LOG_ROOT = "$tmpdir";

my $start = time;
for (1 .. 100) {
    my $pid = fork();
    if (!defined $pid) {
        die "can not fork: $!\n";
    }
    elsif (!$pid) {
        flood();
        exit;
    }
}
wait;
my $t = time - $start;
printf "write time: %.6f\n", $t;

my @lines = path($tmpdir, 'test.log')->lines_utf8();
my $count = scalar @lines;
my @lengths = uniq map { length } @lines;

print "$count lines\n";
print "lengths: ".( join ",", @lengths )."\n";
# my @uniq_lines = uniq @lines;
# print ''.(join "\n", @uniq_lines)."\n";

# path($tmpdir, "test.log")->copy('.');

sub flood
{
    my $log = Yandex::Log->new(
        log_file_name => 'test.log',
        lock => 0,
    );
    for (1 .. 10) {
        $log->out(join ',', (1 .. 2000));
    }
}
