=head1 Yandex::Log::MsgPrefixGuard

    Пакет для использования из Yandex::Log::msg_prefix_guard. Нужен для локальных переопределений префикса
    и возвращения его в исходное значение.

=cut

package Yandex::Log::MsgPrefixGuard;

=head2 new

    Устанавливает на время существования объекта указанный префикс.

    $msg_prefix_guard = Yandex::Log::MsgPrefixGuard($log, $new_msg_prefix);

=cut

sub new {
    my (undef, $log, $new_msg_prefix) = @_;

    my $current_msg_prefix = $log->msg_prefix();
    $log->msg_prefix($new_msg_prefix);

    bless {log => $log, revert_to_msg_prefix => $current_msg_prefix};
}

sub DESTROY {
    my ($self) = @_;

    $self->{log}->msg_prefix($self->{revert_to_msg_prefix});
}

1;
