#!/usr/bin/perl -w

use strict;

use Test::More;
use Test::MockTime qw/:all/;

use Yandex::Log;

set_fixed_time('23/02/2011 12:00:00', '%d/%m/%Y %H:%M:%S');

my @tests = (
    [
     {log_file_name => 'balance.log', dir_name => undef, date_suf => '%Y%m'}
     => ["$Yandex::Log::LOG_ROOT/balance.log.201102", "$Yandex::Log::LOG_ROOT/balance.log"]
    ],
    [
     {log_file_name => 'balance.log', dir_name => undef, date_suf => '%Y%m%d'}
     => ["$Yandex::Log::LOG_ROOT/balance.log.20110223", "$Yandex::Log::LOG_ROOT/balance.log"],
    ],
    [
     {log_file_name => 'balance.log', dir_name => "bal", date_suf => '%Y%m%d'}
     => ["$Yandex::Log::LOG_ROOT/bal/balance.log.20110223", "$Yandex::Log::LOG_ROOT/bal/balance.log"],
    ],
    [
     {log_file_name => 'balance.log', dir_name => "bal", date_suf => '%Y%m%d'}
     => ["$Yandex::Log::LOG_ROOT/bal/balance.log.20110223", undef],
    ],
);

for my $case (@tests) {
    my $log = new Yandex::Log(%{$case->[0]});
    is($log->filename, $case->[1]->[0]);
}
done_testing;
