#!/usr/bin/perl

use strict;
use warnings;
use utf8;

use Test::More;
use Yandex::Test::UTF8Builder;

use Yandex::Log;

# undef -> test_prefix -> undef

my $log = Yandex::Log->new(log_file_name => 'test.log');
is($log->msg_prefix, undef, 'изначально префикса нет');

my $test_prefix = 'test prefix';
my $guard = $log->msg_prefix_guard($test_prefix);
is($log->msg_prefix, $test_prefix, 'созданный guard-объект выставляет новый префикс');

undef $guard;
is($log->msg_prefix, undef, 'после уничтожения guard-объекта возвращается предыдущий префикс [undef]');

# orig_prefix => test_prefix => orig_prefix

my $orig_prefix = 'original prefix';
$log->msg_prefix($orig_prefix);

$guard = $log->msg_prefix_guard($test_prefix);
is($log->msg_prefix, $test_prefix, 'созданный guard-объект выставляет новый префикс');

undef $guard;
is($log->msg_prefix, $orig_prefix, 'после уничтожения guard-объекта возвращается предыдущий префикс [non-undef]');

done_testing;
