#!/usr/bin/perl

use strict;
use Test::More;
use Test::Exception;

use Yandex::Log;

lives_ok sub { Yandex::Log->new(log_file_name => 'test.log') }, 'lives with log_file_name';
dies_ok sub { Yandex::Log->new() }, 'dies without log_file_name';
dies_ok sub { Yandex::Log->new( use_syslog => 1 ) }, 'dies with use_syslog = 1';
dies_ok sub { Yandex::Log->new( use_syslog => 1, no_log => 1 ) }, 'log_file_name required with use_syslog';
lives_ok sub { Yandex::Log->new( no_log => 1 ) };

done_testing;
