#!/usr/bin/perl

use common::sense;

use lib::abs '../lib';
use Yandex::MDS;
use Data::Dump 'pp';
use Path::Tiny;
use List::MoreUtils qw/uniq/;

$Yandex::Log::LOG_ROOT = lib::abs::path('../log');

my $mds = Yandex::MDS->new(
    get_host => 'storage-int.mdst.yandex.net',
    put_host => 'storage-int.mdst.yandex.net:1111',
    authorization => 'ZGlyZWN0LWZpbGVzOjYxMDYxZWU4YmEyM2IzZjI1ZDgwOTJhN2I5MzMwMTk1',
);

print ''.(pp $mds->statistics)."\n";

#######################################

my $test_data = 'test data '.rand();

my $key = $mds->upload('test_data/42/test_'.time().'_'.rand(), $test_data);
print "key = $key\n";

my $got = $mds->get($key);

if ($got eq $test_data) {
    print "get <-> upload matched\n";
}
else {
    print "uploaded '$test_data'\ngot '$got'\n";
}
$mds->delete($key);

eval { $mds->get($key) };
if ($@) {
    if ($@ =~ /404/) {
        print "ok: deleted $key\n";
    }
    else {
        print "unknown error $@\n";
    }
}
else {
    print "$key: not deleted\n";
}

##############################################

my $key = $mds->upload_file($0, 'test.pl.'.rand());

my $code = $mds->get($key);

if ($code eq path($0)->slurp_utf8) {
    print "upload_file ok\n";
}
else {
    print "upload_file failed\n";
}

$mds->delete($key);

##############################################

=doc

Повторная перезапись.
https://clubs.at.yandex-team.ru/storage/138
Вкратце:
Сторадж может попытаться записать существующий файл в ту же группу, где уже есть такой путь; тогда он вернет 403-ю. В теле ответа будет ключ
Если Сторадж будет записывать в другую группу, где такого файла нет, то файл успешно запишется

=cut

my $name = 'update_me';

my $key = $mds->upload($name, 'hey');

my $key2 = $mds->upload($name, 'hey');

print "update attempt: '$key', '$key2'\n";

$mds->delete($_) for uniq($key, $key2);


