#!/usr/bin/perl

use strict;
use warnings;
use utf8;
use Path::Tiny;

use Test::More;
use Test::Yandex::MDS;
use Test::Exception;
use Yandex::MDS;

$Yandex::Log::LOG_ROOT = Path::Tiny::tempdir('yandex-mds-test-XXXXXXXX');

my $ns = 'test';

my $server = Test::Yandex::MDS::mock_server( namespace => $ns, authorization => '42' );

my $host = $server->uri;
$host =~ s!^.+?://!!;
$host =~ s!/$!!g;

lives_ok { Yandex::MDS->new(authorization => '42', namespace => 'test') } 'params validation (minimal)';
dies_ok { Yandex::MDS->new(authorization => '42') } 'params validation (namespace missing)';
dies_ok { Yandex::MDS->new(namespace => 'test') } 'params validation (authorization missing)';
dies_ok { Yandex::MDS->new(authorization => '42', namespace => 'test', get_host => '') } 'params validation (invalid get_host)';
dies_ok { Yandex::MDS->new(authorization => '42', namespace => 'test', put_host => '') } 'params validation (invalid put_host)';

my $mds = Yandex::MDS->new(
    get_host => $host,
    put_host => $host,
    namespace => $ns,
    authorization => '42',
);

my $data = rand();
my $name = 'name_'.rand();

my $key = $mds->upload($name, $data);
my $key2 = $mds->upload($name, $data);

ok($key =~ m!^\d+/$name$!, 'key format');
ok($key eq $key2, '403 returns same key');

{
    no warnings 'redefine';
    my $orig_http_request = \&Yandex::MDS::http_parallel_request;
    my %args;
    local *Yandex::MDS::http_parallel_request = sub {
        (undef, undef, %args) = @_;
        return &$orig_http_request;
    };

    $mds->upload($name, $data);
    ok($args{ipv6_prefer} == 1, 'HTTP-request has ipv6_prefer option');
}

dies_ok { $mds->get('404/404') } 'get dies on 404';

ok($mds->get($key) eq $data, "get");

$mds->delete($key);

lives_ok { $mds->delete($key) } "delete doesn't dies on 404";

done_testing();
