#!/usr/bin/perl

use strict;
use warnings;
use utf8;
use Test::More;
use Yandex::MDS;
use Test::Yandex::MDS;
use Path::Tiny;

$Yandex::Log::LOG_ROOT = Path::Tiny::tempdir('yandex-mds-test-XXXXXXXX');

my $ns = 'test';

my $server = Test::Yandex::MDS::mock_server( namespace => $ns, authorization => '42' );

my $host = $server->uri;
$host =~ s!^.+?://!!;
$host =~ s!/$!!g;

my $mds = Yandex::MDS->new(
    get_host => $host,
    put_host => $host,
    namespace => $ns,
    authorization => '42',
);

my $data = 'this is my file';
my $key = $mds->upload('my_name', \$data);
my $data_copy = $mds->get($key);

ok($data eq $data_copy, "uploaded by ref");

my $p = path($0);
$key = $mds->upload('source', \$p->slurp_raw);
ok($mds->get($key) eq $p->slurp_raw, "from file");


done_testing();
