#!/usr/bin/perl -w

use strict;
use warnings;

use Test::More;
use Test::Memcached;

my $test_memcached = Test::Memcached->new();
$test_memcached->start();

my @SERVERS = ("127.0.0.1:".$test_memcached->option('tcp_port'));

use_ok('Yandex::Memcached::Lock');

my %PARAMS = (
    servers => \@SERVERS,
    entry => 'ut/entry1',
    max_locks_num => 2,
    expire => 10,
    no_auto_lock => 1,
    );

my $mlock1 = Yandex::Memcached::Lock->new(%PARAMS);
my $mlock2 = Yandex::Memcached::Lock->new(%PARAMS);
my $mlock3 = Yandex::Memcached::Lock->new(%PARAMS);

ok($mlock1->lock());
ok($mlock2->lock());
ok(not $mlock3->lock());
ok($mlock2->unlock());
ok($mlock3->lock());
ok($mlock3->unlock());
ok($mlock1->unlock());

# auto_lock
%PARAMS = (
    servers => \@SERVERS,
    entry => 'ut/entry1',
    max_locks_num => 2,
    expire => 10,
    );
my $auto_lock1 = Yandex::Memcached::Lock->new(%PARAMS);
my $auto_lock2 = Yandex::Memcached::Lock->new(%PARAMS);
my $auto_lock3 = Yandex::Memcached::Lock->new(%PARAMS);
ok($auto_lock1->get_lock());
ok($auto_lock2->get_lock());
ok(not $auto_lock3->get_lock());
$auto_lock2 = undef;
$auto_lock3 = Yandex::Memcached::Lock->new(%PARAMS);
ok($auto_lock3->get_lock());

# renew_lock
%PARAMS = (
    servers => \@SERVERS,
    entry => 'ut/entry7',
    max_locks_num => 1,
    expire => 10,
    no_auto_lock => 1
    );
my $single_lock1 = Yandex::Memcached::Lock->new(%PARAMS);
my $single_lock2 = Yandex::Memcached::Lock->new(%PARAMS);
%PARAMS = (
    servers => \@SERVERS,
    entry => 'ut/entry7',
    max_locks_num => 2,
    expire => 10,
    no_auto_lock => 1
    );
my $single_lock3 = Yandex::Memcached::Lock->new(%PARAMS);
ok($single_lock1->lock(), 'setting renewable lock for the first time');
ok($single_lock1->get_lock(), 'getting renewable lock for the first time');
ok($single_lock1->renew_lock(), 'renewing lock');
ok($single_lock1->get_lock(), 'getting renewable lock for the second time');
ok(not ($single_lock2->renew_lock()), 'renewing (locked) lock from "another" process');
ok($single_lock1->unlock(), 'unlocking renewable lock');
ok($single_lock2->lock(), 'setting (unlocked) renewable lock from "another" process');
ok($single_lock2->renew_lock(), 'renewing renewable lock from "another" process');
$single_lock3->lock();
ok(not ($single_lock3->renew_lock()), 'renewing wrongly initialized renewable lock');

%PARAMS = (
    servers => \@SERVERS,
    entry => 'ut/entry8',
    max_locks_num => 10,
    expire => 20,
    );
my $auto_lock4 = Yandex::Memcached::Lock->new(%PARAMS);
my $key = $auto_lock4->{key};
my $value = $auto_lock4->{value};
$auto_lock4->no_auto_unlock(1);
undef $auto_lock4;
%PARAMS = (
    servers => \@SERVERS,
    entry => 'ut/entry8',
    max_locks_num => 10,
    expire => 20,
    no_auto_lock => 1
    );
my $mlock4 = Yandex::Memcached::Lock->new(%PARAMS);
ok($mlock4->associate_lock(key => $key, value => $value));
ok($mlock4->unlock());

# unlock_by_entry
%PARAMS = (
    servers => \@SERVERS,
    entry => 'ut/entry9',
    max_locks_num => 2,
    expire => 10,
    no_auto_lock => 1,
    no_auto_unlock => 1,
);

my $mlock5 = Yandex::Memcached::Lock->new(%PARAMS);
ok($mlock5->lock(), '1 lock for unlock_by_entry');
ok($mlock5->lock(), '2 lock for unlock_by_entry');
ok(! $mlock5->lock(), '3 lock for unlock_by_entry'); # limit exceed
ok($mlock5->unlock_by_entry(), 'unlock_by_entry()'); # first delete all locks
ok($mlock5->lock(), '4 lock for unlock_by_entry');
ok($mlock5->unlock_by_entry(), 'second unlock_by_entry()');
ok($mlock5->lock(), '5 lock for unlock_by_entry');

# не залоченный entry
$PARAMS{entry} = 'ut/entry10';
my $mlock6 = Yandex::Memcached::Lock->new(%PARAMS);
ok(! $mlock6->unlock_by_entry(), 'unlock_by_entry() without lock()');

done_testing();
