#!/usr/bin/perl -w

use strict;
use warnings;
use Time::HiRes qw/time/;

use Test::More;
use Test::Memcached;

use Yandex::Memcached::Lock;

my $test_memcached = Test::Memcached->new();
$test_memcached->start();

$Yandex::Memcached::Lock::TIMEOUT_FIRST = 0.1;

my %PARAMS = (
    servers => ["127.0.0.1:".$test_memcached->option('tcp_port')],
    entry => 'ut/entry1',
    max_locks_num => 2,
    expire => 10,
    );

sub lock {
    return Yandex::Memcached::Lock->new(%PARAMS, @_);
}

{
my $l1 = lock();
my $l2 = lock();
my $l3 = lock();
ok(!$l3->{locked});
}

{
my $l1 = lock(expire => 1, no_auto_unlock => 1);
my $l2 = lock(expire => 2, no_auto_unlock => 1);
my $t1 = time;
my $l3 = lock(timeout => 3);

ok($l3->{locked});
ok(time - $t1 > 0.5);
}

done_testing();
