#!/usr/bin/perl -w

use strict;
use warnings;

use Test::More tests => 4;
use Test::Memcached;

my $test_memcached = Test::Memcached->new();
$test_memcached->start();

my @SERVERS = ("127.0.0.1:".$test_memcached->option('tcp_port'));
my $EXP = 10;

use_ok('Yandex::Memcached');
my $md = Yandex::Memcached->new(servers => \@SERVERS, max_size => 1234);

ok($md->set('ut/key', 'val', $EXP), 'Check availability of '.join(',', @SERVERS));
is($md->get('ut/key'), 'val', 'get check');


my $md1 = Yandex::Memcached->new(servers => \@SERVERS, max_size => 1234, namespace => 'a');
my $md2 = Yandex::Memcached->new(servers => \@SERVERS, max_size => 1234, namespace => 'b');

$md1->set('ut/key', 'val', $EXP);
is($md2->get('ut/key') // '', '', 'Different namespaces have different contents' );


