package Yandex::MetricsLogSender;

=head2 NAME

    Yandex::MetricsLogSender - отправка метрик в java-intapi / metrics.log

=head2 SYNOPSIS

    my $metrics = new Yandex::MetricsLogSender("quasi-make.data", {label => "asfsdf"});
    $metrics->add("build_time", 123.3423, {tag => $tag, ...})
    $metrics->flush();

=cut

use strict;
use warnings;

use Sys::Hostname qw/hostname/;
use Net::INET6Glue::INET_is_INET6;
use JSON;
use LWP::UserAgent;
use Time::HiRes qw//;

use utf8;

our $METRICS_URL //= "http://java-intapi.direct.yandex.net/metrics/add";

sub new {
    my ($class, $prefix, $common_context) = @_;
    return bless {metrics => [], prefix => $prefix, common_context => $common_context};
}

sub add {
    my ($self, $name, $value, $context) = @_;
    push @{$self->{metrics}}, {
        name => ($self->{prefix} ? "$self->{prefix}." : "").$name,
        value => $value,
        context => $context,
    };
}

sub flush {
    my ($self) = @_;
    if (!@{$self->{metrics}}) {
        return;
    }
    my %common_context = (
        uniq_id => generate_uniq_id(),
        login => $ENV{USER},
        hostname => hostname(),
        %{$self->{common_context} || {}},
    );
    my $ua = LWP::UserAgent->new(timeout => 3);
    my $resp = $ua->post($METRICS_URL,
        Content_Type => 'application/json',
        Accept => 'application/json',
        Content => to_json({
            common_context => \%common_context,
            metrics => $self->{metrics},
            }),
    );
    if (!$resp->is_success) {
        die "Can't send metrics: ".$resp->status_line;
    }
    $self->{metrics} = [];
}

sub generate_uniq_id {
    return (
        # из Yandex::Trace
        (int(Time::HiRes::time()*256) & 0x7FFF_FFFF) << 32
        |
        ($$ & 0xFFFF) << 16
        |
        int(rand(0xFFFF))
   ); 
}

1;
