package Yandex::MirrorsTools::Hostings;

# $Id$

=head1 NAME

    Yandex::MirrorTools::Hostings
    Список доменов, которые могут раздавать домены третьего (и выше) уровня на базе своего.
    Как правило это бесплатные хостинги, блоги, порталы, агенства и компании, размещаюшую рекламу в интернете.

=head1 DESCRIPTION

=cut

use warnings;
use strict;

use base qw/Exporter/;
our @EXPORT_OK = qw/strip_domain strip_hosting strip_www get_hostings get_pub2ld splice_domain/;

my @hostings = 
    qw/
       110mb.com
       1bb.ru
       1gb.ru
       3dn.ru
       7910.org
       ac.ru
       aha.ru
       all.biz
       alloka.ru
       allvrn.ru
       altedit.ru
       appee.com
       at.ua
       august4u.ru
       avvea.ru
       biznesua.org
       blogspot.com
       blogspot.ru
       boom.ru
       boxmail.biz
       boxmail.su
       by.ru
       changanauto.ru
       chat.ru
       chel.ru
       cherkassy.ua
       chery.ru
       citroen.ru
       ck.ua
       cn.ua
       crimea.ua
       cv.ua
       da.ru
       deal.by
       diy.ru
       dn.ua
       do.am
       dom.by
       domania.ru
       donetsk.ua
       dp.ua
       e-autopay.com
       e-gloryon.com
       electrob.ru
       energoportal.ru
       eu.ru
       europe-m.ru
       europe-tula.ru
       etov.ua
       fatal.ru
       faw.ru
       firmsite.ru
       fis.ru
       foodset.ru
       fromru.com
       front.ru
       glavsport.ru
       globalmarket.com.ua
       googlepages.com
       h1.ru
       h10.ru
       h100.ru
       h11.ru
       h12.ru
       h14.ru
       h15.ru
       h16.ru
       h17.ru
       h18.ru
       h2.ru
       h2000.ru
       h24.ru
       haval.ru
       himsite.ru
       ho.ua
       host1.ru
       hotbox.ru
       hotmail.ru
       hut1.ru
       hut2.ru
       if.ua
       in.ua
       inc.ru
       instrumenttorg.ru
       io.ua
       irk.ru
       irr.ru
       izhinfo.ru
       jimdo.com
       jino-net.ru
       jino.ru
       justclick.ru
       karelia.ru
       kazan.ws
       kh.ua
       kharkov.ua
       kia-avtomir.ru
       kia.ru
       kiev.ua
       kirov.ru
       komp72.ru
       lact.ru
       lada.ru
       land.ru
       lg.ua
       lgg.ru
       livejournal.com
       lviv.ua
       m2.ru
       mail.ru
       mail333.com
       maxi.by
       mk.ua
       molot.by
       moy.su
       moystart.ru
       mpi.ru
       msn.com
       my1.ru
       mybb.ru
       mylivepage.com
       mylivepage.ru
       narod.ru
       narod2.ru
       nethouse.ru
       newmail.ru
       nm.ru
       nn.ru
       nnov.ru
       nov.ru
       nsk.ru
       nsk.su
       od.ua
       od.ua
       odessa.ua
       odininfo.ru
       of.by
       oir.by
       okis.ru
       opt.ru
       perm.ru
       peugeot.ru
       pisem.net
       pochta.ru
       pp.ru
       pp.ua
       products.in.ua
       prom.ua
       promobud.ua
       pul.ru
       pulscen.ru
       r52.ru
       rambler.ru
       relax.by
       rosmed.ru
       ru.gg
       ru.msn.com
       ruprom.net
       rusmarket.ru
       rusmed.ru
       ryazan.ru
       samr.ru
       saratov.ru
       selec.ru
       satu.kz
       shop.by
       simdif.com
       sitecity.ru
       siteedit.su
       smtp.ru
       spb.ru
       spb.su
       stroi.net
       stroyvitrina.ru
       subaru.ru
       sumy.ua
       superstroy.su
       taba.ru
       tez-tour.com
       tiu.ru
       tom.ru
       tomsk.ru
       torgland.ru
       trade.su
       turbopages.org
       tut.by
       tut.ru
       tut.su
       uaprom.net
       ucoz.com
       ucoz.net
       ucoz.ru
       ucoz.ua
       ufanet.ru
       umi.ru
       ur.ru
       vl.ru
       vn.ua
       web-box.ru
       webhost.ru
       weebly.com
       wix.com
       wmsite.ru
       ya.ru
       yandex.ru
       yaroslavl.ru
       yugs.ru
       zp.ua
       tatet.ru
       lifan-car.ru
       ravon.ru
       tilda.ws
       plp7.ru
       ex-in.online
       bitrix24.site
       mya5.ru
       business.site
       lpmotortest.com 
       lpmotortest.ru
       wixsite.com 
       bmbullet.ru
       bullet.bz
       myflexbe.com
       ukit.me
       usluga.me
       ulcraft.com
     /;

my @public2ld = qw/
       ru
       ua
       msk
       co
       com
       net
       org
       int
       edu
       biz/;

#регексп для доменов
my $h_regexp;

#регексп для для публичных доменом второго уровня.
my $pd_regexp;

#публичные домены второго уровня
my $pub2l_regexp;

#Какой-либо домен вообще
my $some_domain = "[a-z0-9-]+";

my $inited = 0;

=head2 _init

Инициализирует переменные содержашие регэкспы.

=cut

sub _init {
    if (! $inited) {
        #Создаём регексп для доменов
        $h_regexp  = join "|", map { quotemeta $_ } @hostings;
        
        #Создаём регексп для для публичных доменом второго уровня.
        $pd_regexp = join "|", map { quotemeta $_ } @public2ld;

        # Добавляем к списку доменов публичные домены второго уровня
        $pub2l_regexp = "(?:($pd_regexp)\\.[a-z0-9]+)";

        $inited = 1;
    }
}

=head2 set_hostings ($list)

Загружает новый список хостингов.

=cut

sub set_hostings
{
    my ($hostings) = @_;
    @hostings = @$hostings;
    $inited = 0;
}

=head2 strip_domain($href)

    возвращает "владельца" домена с учетом популярных хостингов

=cut
sub strip_domain 
{
    _init();

    my $href = shift;
    # предполагаем, что когда появятся публичные хостинги на русском языке, то они в списке доменов так на русском записываться и будут.
    # но пока таких домено нет, поэтому зазря функцию перевода не вызываем. Расскомментарить следующую строку (и удалить следующую) в случае появления русских доменов.
    # $href = Yandex::IDN::idn_to_unicode(lc($href));

    $href = lc($href);
    my $res = lc($href =~ /([^\/^\?]+)[\/\?]/ ? $1 : $href);
    $res =~ s/\s//g;
    if ($res =~ /([a-z0-9-]+\.(?:$h_regexp|$some_domain|$pub2l_regexp))$/i) {
        return $1;
    } else {
        return $res;
    }
}

=head2 strip_hosting

    Функция удаляет поддомен хостинга, если такой есть

=cut

sub strip_hosting
{
    _init();
    my $href = shift;
    $href = lc($href);

    $href =~ s/\.(?:$h_regexp)$//;
    
    return $href;
}

=head2 strip_www($href)

    Функция отрезает www от домена, в том случае, если он незначим

=cut
sub strip_www {
    _init();
    my $href = shift;
    $href = lc($href);

    my $res = lc($href =~ /([^\/^\?]+)[\/\?]/ ? $1 : $href);

    $res =~ s/
            ^www\.
            (?!
              (?: $h_regexp|$some_domain|$pub2l_regexp )$
            )//x;

    return $res;
}

=head2

    Возвращает ссылку на список доменов

=cut
sub get_hostings {
    return \@hostings;
}

=head2

    Возвращает ссылку на список публичных доменов второго уровня

=cut
sub get_pub2ld {
    return \@public2ld;
}

=head2 splice_domain(domain, level)

    Возвращает домен необходимого уровня с учетом доменных зон.

=cut

sub splice_domain
{
    my $href = shift;
    my $level = shift || 1;

    _init();
    # предполагаем, что когда появятся публичные хостинги на русском языке, то они в списке доменов так на русском записываться и будут.
    # но пока таких домено нет, поэтому зазря функцию перевода не вызываем. Расскомментарить следующую строку (и удалить следующую) в случае появления русских доменов.
    # $href = Yandex::IDN::idn_to_unicode(lc($href));

    $href = lc($href);
    my $res = lc($href =~ /([^\/^\?]+)[\/\?]/ ? $1 : $href);
    $res =~ s/\s//g;

    if ($res =~ /((?:[a-z0-9-]+\.){1,\Q$level\E}(?:$pub2l_regexp|$some_domain))$/i) {
        return $1;
    } else {
        return $res;
    }
}

1;
__END__
