#!/usr/bin/perl -w

use strict;
use warnings;

use Test::More qw/no_plan/;
use Yandex::MirrorsTools::Hostings qw/splice_domain strip_hosting strip_domain/;

is( splice_domain('sedano.ru'), 'sedano.ru', 'identity' );
is( splice_domain('mail.sedano.ru',1), 'sedano.ru', 'first level splice' );
is( splice_domain('data.ru.com',1), 'data.ru.com', 'public domain was saved' );
is( splice_domain('data.com.ru'), 'data.com.ru', 'NO level - no splicing');

is( splice_domain('dom3.dom2.dom1.ru',1), 'dom1.ru', '1 level splicing');
is( splice_domain('dom3.dom2.dom1.ru',2), 'dom2.dom1.ru', '2 level splicing');
is( splice_domain('dom3.dom2.dom1.ru',3), 'dom3.dom2.dom1.ru', '3 level splicing');
is( splice_domain('dom3.dom2.dom1.ru',40), 'dom3.dom2.dom1.ru', 'Overwhelmed level');

is( strip_hosting('mydomain.livejournal.com'), 'mydomain', 'Hosting was stripped');
is( strip_hosting('mydomain.notahosting.com'), 'mydomain.notahosting.com', 'Hosting was stripped');

is( strip_domain('sedano.ru'),'sedano.ru');
is( strip_domain('www.sedano.ru'),'sedano.ru');
is( strip_domain('www.sedano.ru'),'sedano.ru');
is( strip_domain('mail.my.globalmarket.com.ua'), 'my.globalmarket.com.ua');

Yandex::MirrorsTools::Hostings::set_hostings(['my.hosting.com']);
is( strip_hosting('mydomain.my.hosting.com'), 'mydomain', 'Hosting was stripped');
is( strip_hosting('mydomain.livejournal.com'), 'mydomain.livejournal.com', 'Hosting was stripped');
is( strip_domain('mail.my.globalmarket.com.ua'), 'globalmarket.com.ua');
is( strip_domain('mail.my.my.hosting.com'), 'my.my.hosting.com');

exit 0;

__END__
