package Yandex::MisspellChecker::Response::JSON;

=head1 NAME

Yandex::MisspellChecker::Response::JSON

=cut

use strict;
use warnings;
use utf8;

use base 'Yandex::MisspellChecker::Response';

use JSON 'decode_json';
use Encode 'encode_utf8';

use constant {

    KEYS_MAP => {
        map( { ucfirst( $_ ) => $_ } ( 'code', 'lang', 'rule', 'flags' ) ),
        Relevance => 'reliability',
    },
    DELIMITER => "\7",
};

sub parse {

    my ( $self, %options ) = @_;
    my $data = $self -> { 'data' } = ( $options{ 'data' } // $self -> { 'data' } // '' );
    my %output = ();

    $data = decode_json( utf8::is_utf8( $data ) ? encode_utf8( $data ) : $data );

    while( my ( $from, $to ) = each( %{ +KEYS_MAP } ) ) {

        if( exists $data -> { $from } ) {

            $output{ $to } = $data -> { $from };
        }
    }

    $self -> { 'result' } = \%output;

    # если сервис поискового опечаточника считает. что запрос к нему не содержал ошибок,
    # либо он их не смог исправить, либо был сделан к нему неправильный запрос,
    # то вернём только значения атрибутов корневого элемента
    return %output if ( $output{ 'code' } != Yandex::MisspellChecker::Response::MSRESP_CODE_CORRECTED );

    # запрос к поисковому опечаточнику содержал ошибки и они были исрпавлены

    # исходный текст запроса и исправленный текст
    @output{ 'srcText', 'fixedText' } = @$data{ 'SrcText', 'Text' };

    my $delimiter = DELIMITER;

    if( $output{ 'srcText' } ) {

        $output{ 'misspells' } = [
            map( {
                ( my $word = $_ ) =~ s/${delimiter}[\(\)]//g;
                $word =~ s/^\W+//;
                $word =~ s/\W+$//;
                $word;
            }
            grep( { $_ =~ m/${delimiter}[\(\)]/ }
            split( /\s+/, $output{ 'srcText' } ) ) )
        ];

        if( $options{ 'need_highlight' } ) {

            ( $output{ 'hilightedText' } = $output{ 'srcText' } ) =~
                s#${delimiter}\((.*?)${delimiter}\)#<font color="red">$1</font>#g;
        }
    }

    foreach my $key ( 'srcText', 'fixedText' ) {

        if( $output{ $key } ) {

            $output{ $key } =~ s/${delimiter}[\(\)]//g;
        }
    }

    return %output;
}

1;

__END__
