#!/usr/bin/perl -w

use strict;
use warnings;

use JSON 'decode_json';
use Encode 'decode_utf8';

use Test::More tests => 5;

BEGIN { use_ok 'Yandex::MisspellChecker::Response::JSON' };

my $object_1 = new_ok( 'Yandex::MisspellChecker::Response::JSON' );

$object_1 -> parse(
    data => decode_utf8( <<RESPONSE_1
{
"Passes": [
  {

  },
  {

  }
],
"SrcText": "п\\u0007(оо\\u0007)лировка",
"Text": "п\\u0007(о\\u0007)лировка",
"Code": 201,
"Relevance": 10000,
"Lang": "ru,en",
"Flags": "",
"Rule": "Misspell"
}
RESPONSE_1
    ),
    need_highlight => 0,
);

my $object_2 = new_ok( 'Yandex::MisspellChecker::Response::JSON' );

$object_2 -> parse(
    data => decode_utf8( <<RESPONSE_1
{
"Passes": [
  {

  },
  {

  }
],
"SrcText": "п\\u0007(оо\\u0007)лировка",
"Text": "п\\u0007(о\\u0007)лировка",
"Code": 201,
"Relevance": 10000,
"Lang": "ru,en",
"Flags": "",
"Rule": "Misspell"
}
RESPONSE_1
    ),
    need_highlight => 1,
);

is_deeply( $object_1 -> { 'result' }, decode_json( <<SAMPLE_1
{
    "reliability": 10000,
    "lang": "ru,en",
    "flags": "",
    "rule": "Misspell",
    "misspells": [
        "поолировка"
    ],
    "srcText": "поолировка",
    "fixedText": "полировка",
    "code": 201
}
SAMPLE_1
), 'need_highlight=0' );

is_deeply( $object_2 -> { 'result' }, decode_json( <<SAMPLE_2
{
    "reliability": 10000,
    "lang": "ru,en",
    "flags": "",
    "rule": "Misspell",
    "misspells": [
        "поолировка"
    ],
    "hilightedText": "п<font color=\\"red\\">оо</font>лировка",
    "srcText": "поолировка",
    "fixedText": "полировка",
    "code": 201
}
SAMPLE_2
), 'need_highlight=1' );

exit 0;

__END__
