#!/usr/bin/perl -w

use utf8;
use strict;
use warnings;

use Data::Dumper;
#use Test::More tests => 4;
use Test::More skip_all => 'this test is broken';
use Yandex::MisspellChecker::Response;

require_ok('Yandex::MisspellChecker');
require_ok('Yandex::MisspellChecker::Response');

use constant {
    WORD_CORRECT    => 'корова',
    WORD_INCORRECT  => 'карова',
};

my $checker = Yandex::MisspellChecker->new( lang => 'ru', fix => 1, is_test => 1 );
my %params = ( safety => 1, timeout => 60, need_highlight => 0 );

my $expected_incorrect = bless( {
                 'result' => {
                               'reliability' => '8000',
                               'flags' => '0',
                               'lang' => 'ru',
                               'rule' => 'Misspell',
                               'misspells' => [
                                                WORD_INCORRECT
                                              ],
                               'srcText' => WORD_INCORRECT,
                               'fixedText' => WORD_CORRECT,
                               'code' => 201
                             }
               }, 'Yandex::MisspellChecker::Response' );

my $expected_correct =  bless( {
                 'result' => {
                               'reliability' => '0',
                               'flags' => '0',
                               'lang' => 'ru',
                               'rule' => '',
                               'code' => 200
                             }
               }, 'Yandex::MisspellChecker::Response' );

is_deeply( $checker->check([ WORD_CORRECT, WORD_INCORRECT ], %params ), 
		[ $expected_correct, $expected_incorrect ], 
		'Order 1' 
	);

is_deeply( $checker->check([ WORD_INCORRECT, WORD_CORRECT ], %params ), 
		[ $expected_incorrect, $expected_correct ], 
		'Order 2' 
	);
