package Yandex::ML::KMeans;

use strict;
use warnings;

use Data::Dumper;
use List::Util;
use Clone qw(clone);
use Yandex::ML::Point;
use Yandex::ML::PointsMean;

use base 'Yandex::ML::Clustering';

sub new($$$;$)
{
    my ($class, $k, $dimensions) = @_;

    my $self =  $class->SUPER::new($k);
    
    $self->{dimensions} = $dimensions;
    $self->{k} = $k;

    unless ($self->{dimensions}) {
        die "no dimension specified";
    }

    return $self;
}


#
#Инициализация для алгоритма k-means
#Выбирает начальные центроиды. В качестве начальных центроиов выбираем сымые удаленные друг от друга точки.
#
sub init
{
    my ($self) = @_;
    
    my $points = $self->get_points_ref();
    my %visited;

    my $last_model = int( rand(@$points) );

    for (my $i = 0; $i < $self->{k}; $i++) {
        my $previous = $points->[ $last_model ];
        my $distance = 0;
        my $current;

        for (my $j = 0; $j < @$points; $j++) {
            next if exists $visited{$j};
            my $new_distance = $previous->euclidian( $points->[$j] );

            if ($new_distance > $distance) {
                $current = $j;
                $distance = $new_distance;
            }
        }
        
        if (!defined $current) {
            die "No points for initialization";
        }

        $self->add_to_centroid(undef, $current);
        $visited{ $current } = 1;
        $last_model = $current;
    }
}

sub make_new_point
{
    my ($self, $point_id, $point) = @_;
    return Yandex::ML::Point->new( $point_id, $self->{dimensions} )->init_point($point);
}

sub make_new_centroid
{
    my ($self) = @_;
    return Yandex::ML::PointsMean->new($self->{dimensions}); 
}

sub new_centroid_is_better
{
    my ($self, $dst) = @_;
    if ($dst > 7) { return 1 };
    return 0;
}

sub is_better_distance
{
    my ($self, $current_better_dist, $distance) = @_;

    return 1 unless defined $current_better_dist;
    
    my $diff = $current_better_dist - $distance;
    
    if ($diff > 0.0001) {
        return 1;
    }
    
#    if ($distance <  $current_better_dist) {
#        return 1;
#    }

    return 0;
}


1;
