package Yandex::ML::Point;

#Пакет представляет точку в виде вектора с координатами.
#На данынй момнемт ветора очень большие ( около 30_000 позиций) и разреженные ( из 30000 может бытьв сего  2-3 элемента отличных от нуля.
#Поэтому здесь каждая точка релизована как хеш.
#
#Если  координаты будут занимать мньеше места то оптимальнее будет перети на представление в виде массива - 
#прирост производительности должен быть ощутимый.


use strict;
use warnings;

use List::MoreUtils qw(uniq);
use Data::Dumper;
use Clone;

my $MAX_ARRAY_SIZE = 1000;

sub new($$$)
{
    my ($class, $point_id, $dimensions) = @_;

    my $self = {};
    
    $self->{id} = $point_id;
    $self->{dimensions} = $dimensions;

    if ($dimensions < $MAX_ARRAY_SIZE) {
        $self->{coordinates} = []; 
    }
    else {
        $self->{coordinates} = {};
    }

    return bless $self, $class;
}

sub init_point($$)
{
    my  ($self, $coordinates) = @_;
    
    foreach my $k (keys %$coordinates) {
        if ($k < 0 || $k > $self->{dimensions}) {
            die "Bad point ".Dumper($coordinates);
        }

        if ( $self->{dimensions} < $MAX_ARRAY_SIZE) {
            $self->{coordinates}[$k] = $coordinates->{$k};
        }
        else {
            $self->{coordinates}{$k} = $coordinates->{$k};
        }
    }

    return $self;
}

sub id
{
    return $_[0]->{id};
}

sub dimensions
{
    my ($self) = @_;

    return $self->{dimensions};
}

#для списка точек возвращяет оси по которым у них есть ненулевые значения
sub get_all_used_coords
{
    my ($self, @points) = @_;
    
    if ($self->{dimensions} < $MAX_ARRAY_SIZE) {
        unless(@points) {
            my @result = (0..($self->{dimensions}-1));
            return @result;
        }

        return uniq map { $_->get_all_used_coords(); } @points;
    }

    return keys %{ $self->{coordinates} } unless @points;

    return uniq map {  keys %{ $_->{coordinates } } } @points;
}

#Возвращает координату по номеру
sub get_coord
{
    my ($self, $n) = @_;
    
    if ($self->{dimensions} < $MAX_ARRAY_SIZE) {
        return $self->{coordinates}[$n] || 0;
    }
    else {
        return exists $self->{coordinates}{$n} ? $self->{coordinates}{$n} : 0;
    }
}


sub set_coord
{
    my ($self, $n, $value) = @_;

    if ($value || $self->{dimensions} < $MAX_ARRAY_SIZE) {
        if ($self->{dimensions} < $MAX_ARRAY_SIZE) {
            $self->{coordinates}[$n] = $value;
        }
        else {
            $self->{coordinates}{$n} = $value;
        }
    }
    else {
        delete $self->{coordinates}{$n};
    }

}

sub cosine_distance
{
    my ($self, $to) = @_;
    my @coords = uniq ( keys %{$self->{coordinates}}, keys %{ $to->{coordinates} } );
    
    my $cos = 0;

    foreach (@coords) {
        my $a = (exists $self->{coordinates}{$_} ? $self->{coordinates}{$_} : 0);
        my $b = (exists $to->{coordinates}{$_} ? $to->{coordinates}{$_} : 0);
        
        if ($a && $b) {
            $cos += $a * $b;
        }
    }
    
    return 1-$cos;
}

#Считаем Евклидово расстояние между точками
sub euclidian
{
    my ($self,  $to) = @_;
    
    my $result = 0;
    
    if ( $self->{dimensions} < $MAX_ARRAY_SIZE)   {
        foreach (0 .. ($self->{dimensions} - 1)) {
            $result += abs(  ($self->{coordinates}[$_] || 0) - ($to->{coordinates}[$_] || 0) );
        }
    }
    else {
        my @coords = uniq ( keys %{$self->{coordinates}}, keys %{ $to->{coordinates} } );
    
        foreach (@coords) {
            my $a = (exists $self->{coordinates}{$_} ? $self->{coordinates}{$_} : 0.0001);
            my $b = (exists $to->{coordinates}{$_} ? $to->{coordinates}{$_} : 0.0001);

            $result += abs($a-$b);
        }
    }

    return $result;
}

sub pearson
{
    my ($self, $to) = @_;
    
    my @coords = uniq ( keys %{$self->{coordinates}}, keys %{ $to->{coordinates} } );
    
    my $dim = $self->{dimensions};

    my ($sum1, $sum2);
    
    foreach (@coords) {
        $sum1 += $self->get_coord($_);
        $sum2 += $to->get_coord($_);
    }
    
    my ($sum1Sq, $sum2Sq);

    foreach (@coords) {
        $sum1Sq += $self->get_coord($_)**2;
        $sum2Sq += $to->get_coord($_)**2;
    }
    
    my $pSum;

    foreach (@coords) {
        $pSum += $self->get_coord($_) * $to->get_coord($_);
    }
    
    my $num = $pSum - ($sum1 * $sum2/$dim);
    
    my $denom = sqrt(($sum1Sq - $sum1**2/$dim) * ( $sum2Sq - $sum2**2/$dim  ) );
    
    if ($denom == 0) {
        return 0;
    }
    
    #Чем меньше число вернем тем точки более схожи.
    return 1-$num/$denom;
}

1;
