package Yandex::ML::PointsMean;

use strict;
use warnings;

use base 'Yandex::ML::Point';

my $centroid_id = 0;

use Data::Dumper;

sub new
{
    my ($class, $dimensions, $epsilon) = @_;
    my $self = $class->SUPER::new('__centroid_'.$centroid_id++, $dimensions);
    
    $self->{count} = 0;
    #$self->{dimensions} = $dimensions;
    $self->{epsilon} = $epsilon || 0.1;
    $self->{updated} = 0;

    return bless $self, $class;
}

sub distance
{
    my ($self, $point) = @_;
    return $self->point()->euclidian($point);
}

sub compare
{
    my ($c1, $c2) = @_;
    
    my $diff = $c1->point()->euclidian($c2->point());
    
    if ($diff >= $c1->{epsilon}) {
        return 1;
    }
    
    return 0;
}

sub count($)
{
    my ($self) = @_;
    return $self->{count};
}

sub add_centroid($$)
{
    my ($c1, $c2) = @_;
    
    return unless $c1 && $c2;

    $c1->{count} += $c2->count();
    $c1->add_point($c2->point());
}

sub attributes
{
    my ($self) = @_;
    return $self->get_all_used_coords();
}

sub add_point($$)
{
    my ($self, $point) = @_;
    
    $self->{count}++;
    
    my @coords = $point->get_all_used_coords();

    foreach (@coords) {
        $self->SUPER::set_coord( $_,  $self->SUPER::get_coord($_) + $point->get_coord($_) );
    }

    $self->{updated} = undef;
}

sub remove_point($$)
{
    my ($self, $point) = @_;
    
    $self->{count}--;
    
    return undef unless $self->{count};
    
    my @coords = $point->get_all_used_coords();
    
    foreach (@coords) {
        my $rc = $self->SUPER::get_coord($_) - $point->get_coord($_);
        
        $rc = 0 if $rc < 0;
        $self->SUPER::set_coord( $_,  $rc );
    }

    $self->{updated} = undef;

    return 0;
}

sub get_coord
{
    my ($self, $coord) = @_;
    return int($self->SUPER::get_coord($coord) / $self->{count} + 0.5);
}

#sub set_coord
#{
#    my ($self);
#    die "called set_coord for PointsMean class!";
#}

#Эта обертка нужна, т.к базоыфй класс Point не испоьзует методы get_/set_coord, а обращается в значениям напрямую
sub point($)
{
    my ($self) = @_;
    
    if (!$self->{updated}) {
        my @coords = $self->get_all_used_coords();
    
        $self->{updated} = new Yandex::ML::Point(0, $self->{dimensions});

        foreach (@coords) {
#            my $new_coord = int($self->SUPER::get_coord($_) / $self->{count} + 0.5);
            $self->{updated}->set_coord( $_,  $self->get_coord($_)  );
        }
    }
    
    return $self->{updated};
}

1;
