package Yandex::ML::SClope::FP;
use strict;
use warnings;

use constant CHART           => 0;
use constant MICROCLUSTER_TRANSACTIONS   => 1;

use Data::Dumper;
use Yandex::Trace;

use vars qw(%FIELDS);

use constant  {
    ID                          => 0,
    ATTRIBUTE                   => 1,
    WEIGHT                      => 2,
    PARENT_ID                   => 3,
    CHILDREN_IDS_BY_ATTRIBUTES => 4,
    CHILDREN_ATTRIBUTES_BY_IDS => 5,
    TRANSACTIONS                => 6,
    MICROCLUSTERS               => 7,
    HEIGHT                      => 8,
};

sub new {
    # инищализируем дерево
    my $class = shift;
    my $self = {};
    bless $self, $class;
    $self->{nCount} = 0;            # ноды
    $self->{nClusterCount} = 1;     # кластеры
    $self->{nodes} = [];

    # корневая нода
    $self->{nodes}[0][ ID ]                         = 0;
    $self->{nodes}[0][ ATTRIBUTE ]                  = '';
    $self->{nodes}[0][ WEIGHT ]                     = 0;
    $self->{nodes}[0][ PARENT_ID ]                  = -1;
    $self->{nodes}[0][ CHILDREN_IDS_BY_ATTRIBUTES ] = {};
    $self->{nodes}[0][ CHILDREN_ATTRIBUTES_BY_IDS ] = {};
    $self->{nodes}[0][ TRANSACTIONS ]                   = {};
    $self->{nodes}[0][ MICROCLUSTERS ]              = {};
    $self->{nodes}[0][ HEIGHT ]                     = 0;

    $self->{microclusters} = {}; # микрокластеры
    
    return $self;

    # у каждого микрокластера есть:  список нод, которые в него входят, диаграммы атрибутов
}

sub insert_transaction {
    my ( $self, $transaction ) = @_;
    
    my $profile = Yandex::Trace::new_profile('ml:sclope:fp:insert_transaction');

    my $cluster2insert = 0; 
    # по умолчанию новый кластер - все транзакции подклеиваются начиная с корневой ноды
    # вычсляется номер кластера

    my $nCurrentNode = 0;
    
    my $hit = 0;

#    warn Dumper($transaction);

    for ( my $attr_index = 0; $attr_index < scalar( @{$transaction->{attributes}} ); $attr_index++ ) {
        my $attr = $transaction->{attributes}->[$attr_index];
        my $oCurrentNode = $self->{nodes}[$nCurrentNode]; # текущая нода, в детях которой должен быть найденный атрибут
        $cluster2insert = 0;
        
        # концевая нода
        if ( scalar( keys %{ $oCurrentNode->[ CHILDREN_IDS_BY_ATTRIBUTES ] } ) == 0 ) {
            if ( $nCurrentNode != 0 ) {
                my @cluster_keys = sort keys %{ $self->{nodes}[ $nCurrentNode ]->[ MICROCLUSTERS ] };
                $cluster2insert = $cluster_keys[0];
            }

            last;
        }

        # не концевая нода, но нашего атрибута нет
        last if ( !exists( $oCurrentNode->[ CHILDREN_IDS_BY_ATTRIBUTES ]{$attr} ) );

        $nCurrentNode = $oCurrentNode->[ CHILDREN_IDS_BY_ATTRIBUTES ]{$attr};
    } # по атрибутам

    # новый кластер
    if ( $cluster2insert == 0 ) {
        $cluster2insert = $self->{nClusterCount}++;
        $self->{microclusters}{ $cluster2insert }[MICROCLUSTER_TRANSACTIONS] = {};
        $self->{microclusters}{ $cluster2insert }[CHART] = {};
    }

    # 
    # вставляем транзакцию
    $self->_insert( $cluster2insert, $transaction );
    
    #die Dumper($self);
}

# процедура добавления транзакции к дереву, начиная с некоторого дитя node_id
sub _insert {
    my ( $self, $cluster_id, $transaction ) = @_;
    # для всех атрибутов транзакции выстроить их приклеивая к корневой ноде
    my $transaction_id = $transaction->{id} or die "no id in transaction!\n";
    my $parent_node_id = 0;
    my $current_node_id;

    # транзакцию в кластер
    $self->{microclusters}{$cluster_id}[MICROCLUSTER_TRANSACTIONS]{$transaction_id} = 1;

    for my $attr ( @{$transaction->{attributes}} ) {
        if ( defined( $self->{nodes}[$parent_node_id]->[CHILDREN_IDS_BY_ATTRIBUTES]{$attr} ) ) {
            # старая нода
    #        warn "Add attribute to existent node!";
            $current_node_id = $self->{nodes}[$parent_node_id]->[CHILDREN_IDS_BY_ATTRIBUTES]{$attr};
            $self->{nodes}[$current_node_id]->[WEIGHT]++;
            $self->{nodes}[$current_node_id]->[TRANSACTIONS]{$transaction_id} = 1;
            
        } else {
            # новая нода
            #        warn "Create new node!";
            $current_node_id = ++$self->{nCount};
            $self->{nodes}[ $current_node_id ]->[ID] = $current_node_id;
            $self->{nodes}[ $current_node_id ]->[ATTRIBUTE] = $attr;
            $self->{nodes}[ $current_node_id ]->[WEIGHT] = 1;
            $self->{nodes}[ $current_node_id ]->[PARENT_ID] = $parent_node_id;
            $self->{nodes}[ $current_node_id ]->[CHILDREN_ATTRIBUTES_BY_IDS] = {};
            $self->{nodes}[ $current_node_id ]->[CHILDREN_IDS_BY_ATTRIBUTES] = {};
            $self->{nodes}[ $current_node_id ]->[TRANSACTIONS] = {$transaction_id => 1};
            $self->{nodes}[ $current_node_id ]->[MICROCLUSTERS] = {};
            $self->{nodes}[ $current_node_id ]->[HEIGHT] = $self->{nodes}[$parent_node_id]->[HEIGHT] + 1;

            # добавим информацию про новую ноду к родителю
            $self->{nodes}[ $parent_node_id ]->[CHILDREN_ATTRIBUTES_BY_IDS]{$current_node_id}   = $attr;
            $self->{nodes}[ $parent_node_id ]->[CHILDREN_IDS_BY_ATTRIBUTES]{$attr}              = $current_node_id;
        };
        
        $self->{nodes}[$current_node_id]->[MICROCLUSTERS]{$cluster_id} = 1;     # кластер в ноду

        $self->{microclusters}{$cluster_id}[CHART]{$attr}++;                        # гистограмма
        $parent_node_id = $current_node_id;                                         # новый parent
    
    } # for attribute
}

1;
