#!/usr/bin/perl

# Юнит тесты на parse_store_url

use strict;
use warnings;
use utf8;

use Yandex::CheckMobileRedirect;
use Yandex::Test::UTF8Builder;

use Test::More;
use JSON;

my @tests = (
    # [$input, $expected_out]
    # Google Play
    # Apps
    ['"https://play.google.com/store/apps/details?id=com.avtofriend.com.avtofriend"', {store_content_id => 'com.avtofriend.com.avtofriend', store_country => 'RU', os_type => 'Android', content_type => 'app', is_default_country => 1}],
    ['https://play.google.com/store/apps/details?id=com.avtofriend.com.avtofriend', {store_content_id => 'com.avtofriend.com.avtofriend', store_country => 'RU', os_type => 'Android', content_type => 'app', is_default_country => 1}],
    ['http://play.google.com/store/apps/details?id=com.netmarble.mherosgb&gl=ua', {store_content_id => 'com.netmarble.mherosgb', store_country => 'UA', os_type => 'Android', content_type => 'app', is_default_country => 0}],
    # страна большими буквами
    ['http://play.google.com/store/apps/details?id=com.netmarble.mherosgb&gl=UA', {store_content_id => 'com.netmarble.mherosgb', store_country => 'UA', os_type => 'Android', content_type => 'app', is_default_country => 0}],
    # страна буквами разного регистра
    ['http://play.google.com/store/apps/details?id=com.netmarble.mherosgb&hl=uK', {store_content_id => 'com.netmarble.mherosgb', store_country => 'RU', os_type => 'Android', content_type => 'app', is_default_country => 1}],
    ['http://play.google.com/store/apps/details?id=com.netmarble.mherosgb&hl=uk_RU', {store_content_id => 'com.netmarble.mherosgb', store_country => 'RU', os_type => 'Android', content_type => 'app', is_default_country => 1}],
    ['http://play.google.com/store/apps/details?id=com.netmarble.mherosgb&hl=tr_RU', {store_content_id => 'com.netmarble.mherosgb', store_country => 'RU', os_type => 'Android', content_type => 'app', is_default_country => 1}],
    ['play.google.com/store/apps/details?id=com.halfbrick.fruitninjafree&foo=baz&hl=tr&param=blah', {store_content_id => 'com.halfbrick.fruitninjafree', store_country => 'RU', os_type => 'Android', content_type => 'app', is_default_country => 1}],
    ['play.google.com/store/apps/details?id=com.halfbrick.fruitninjafree&foo=baz&hl=tr&gl=by&param=blah', {store_content_id => 'com.halfbrick.fruitninjafree', store_country => 'BY', os_type => 'Android', content_type => 'app', is_default_country => 0}],
    ['play.google.com/store/apps/details?id=com.halfbrick.fruitninjafree&foo=baz&hl=kk&param=blah', {store_content_id => 'com.halfbrick.fruitninjafree', store_country => 'RU', os_type => 'Android', content_type => 'app', is_default_country => 1}],
    # некорректный параметр gl
    ['play.google.com/store/apps/details?id=com.halfbrick.fruitninjafree&gl=x', {store_content_id => 'com.halfbrick.fruitninjafree', store_country => 'RU', os_type => 'Android', content_type => 'app', is_default_country => 1}],
    ['play.google.com/store/apps/details?id=com.halfbrick.fruitninjafree&gl=turkey', {store_content_id => 'com.halfbrick.fruitninjafree', store_country => 'RU', os_type => 'Android', content_type => 'app', is_default_country => 1}],

    ['https://play.baidu.com/store/apps/details?id=air.isporch&hl=tr', undef],
    ['https://play.google.com/store/apps/details?id=&hl=tr', undef],
    ['https://play.google.com/store/details?id=air.isporch&hl=tr', undef],
    ['https://play.google.com/store/details?id=air.isporchhl=tr', undef],
    ['https://play.google.com/store/details?id=ru.sutochno_redesignttps://itunes.apple.com/app/id973070068', undef],
    ['https://play.google.com/store/details?id=com.surpax.ledflashlight.panel=http:2percentTO2percentTOroem.ru', undef],
    # Пока поддерживаем только приложения, остальные типы контента недоступны
    ['https://play.google.com/store/movies/details/Маша_и_медведь_Крик_победы?id=uHSGpaaMREw', undef],
    ['https://play.google.com/store/books/details/Э_Джеймс_Пятьдесят_оттенков_серого?id=93RRKy9sEkIC&hl=ru', undef],
    ['https://play.google.com/store/music/album/Various_Artists_Золушка_Оригинальный_саундтрек?id=B3tgwz5c2gsskfikedprxspatrq', undef],
    ['https://play.google.com/store/newsstand/details/Коммерческий_директор?id=CAow98zSAQ', undef],
    # # Films
    # ['https://play.google.com/store/movies/details/Маша_и_медведь_Крик_победы?id=uHSGpaaMREw', {store_content_id => 'uHSGpaaMREw', store_country => 'RU', os_type => 'Android', content_type => 'movie'}],
    # ['http://play.google.com/store/movies/details/Духless_2?id=9AaSdvC7r28&hl=uk', {store_content_id => '9AaSdvC7r28', store_country => 'UA', os_type => 'Android', content_type => 'movie'}],
    # ['play.google.com/store/movies/details/Kingsman_Секретная_Служба?id=5qONnQKzUzc&foo=baz&hl=tr&param=blah', {store_content_id => '5qONnQKzUzc', store_country => 'TR', os_type => 'Android', content_type => 'movie'}],
    # ['play.google.com/store/movies/details/Kingsman_Секретная_Служба?hl=tr&foo=baz&id=5qONnQKzUzc&param=blah', {store_content_id => '5qONnQKzUzc', store_country => 'TR', os_type => 'Android', content_type => 'movie'}],
    # ['https://play.google.com/store/movies/details/?id=9AaSdvC7r28', {store_content_id => '9AaSdvC7r28', store_country => 'RU', os_type => 'Android', content_type => 'movie'}],
    # ['https://play.baidu.com/store/movies/details/Kingsman_Секретная_Служба?id=5qONnQKzUzc&hl=tr', undef],
    # ['https://play.google.com/store/movies/details/?id=&hl=tr', undef],
    # # Books
    # ['https://play.google.com/store/books/details/Э_Джеймс_Пятьдесят_оттенков_серого?id=93RRKy9sEkIC&hl=ru', {store_content_id => '93RRKy9sEkIC', store_country => 'RU', os_type => 'Android', content_type => 'book'}],
    # ['http://play.google.com/store/books/details/Николай_Васильевич_Гоголь_Мертвые_души_Иллюстриров?id=xciipl7RoRQC&hl=uk', {store_content_id => 'xciipl7RoRQC', store_country => 'UA', os_type => 'Android', content_type => 'book'}],
    # ['play.google.com/store/books/details/Энди_Вейер_Марсианин?id=w5yuBAAAQBAJ&foo=baz&hl=tr&param=blah', {store_content_id => 'w5yuBAAAQBAJ', store_country => 'TR', os_type => 'Android', content_type => 'book'}],
    # ['https://play.google.com/store/books/details/Федор_Михайлович_Достоевский_Идиот_Роман?id=-S8IAgAAQBAJ', {store_content_id => '-S8IAgAAQBAJ', store_country => 'RU', os_type => 'Android', content_type => 'book'}],
    # ['https://play.baidu.com/store/books/details/Анджей_Сапковский_Ведьмак_сборник?id=gIMRBAAAQBAJ&hl=tr', undef],
    # ['https://play.google.com/store/books/details/?id=&hl=tr', undef],
    # # Music
    # ['https://play.google.com/store/music/album/Various_Artists_Золушка_Оригинальный_саундтрек?id=B3tgwz5c2gsskfikedprxspatrq', {store_content_id => 'B3tgwz5c2gsskfikedprxspatrq', store_country => 'RU', os_type => 'Android', content_type => 'music'}],
    # ['http://play.google.com/store/music/album/Jamie_Foxx_Hollywood_A_Story_of_a_Dozen_Roses?id=Bmyohgax3ogylqqa4ovuxd4e3c4&hl=uk', {store_content_id => 'Bmyohgax3ogylqqa4ovuxd4e3c4', store_country => 'UA', os_type => 'Android', content_type => 'music'}],
    # ['play.google.com/store/music/album/London_Philharmonic_Orchestra_The_50_Greatest_Piec?id=B47y3y7zx4osuympodr7dmyhpwu&foo=baz&hl=tr&param=blah', {store_content_id => 'B47y3y7zx4osuympodr7dmyhpwu', store_country => 'TR', os_type => 'Android', content_type => 'music'}],
    # ['https://play.google.com/store/music/album?id=Bb6qc6b5nffqvmjpth5u5d6mrta&hl=ru', {store_content_id => 'Bb6qc6b5nffqvmjpth5u5d6mrta', store_country => 'RU', os_type => 'Android', content_type => 'music'}],
    # ['https://play.baidu.com/store/music/album/5_NIZZA_Пятница?id=Bknqdqv2lnhdkjh7tixrs4wb2im&hl=tr', undef],
    # ['https://play.google.com/store/music/details/?id=&hl=tr', undef],
    # # Newsstand
    # ['https://play.google.com/store/newsstand/details/Коммерческий_директор?id=CAow98zSAQ', {store_content_id => 'CAow98zSAQ', store_country => 'RU', os_type => 'Android', content_type => 'newsstand'}],
    # ['http://play.google.com/store/newsstand/news/Российская_Газета?id=CAownbXoAQ&hl=uk', {store_content_id => 'CAownbXoAQ', store_country => 'UA', os_type => 'Android', content_type => 'newsstand'}],
    # ['play.google.com/store/newsstand/details/Популярная_механика?id=CAowgq2eCQ&foo=baz&hl=tr&param=blah', {store_content_id => 'CAowgq2eCQ', store_country => 'TR', os_type => 'Android', content_type => 'newsstand'}],
    # ['https://play.google.com/store/newsstand/details/?id=CAowkayeCQ&hl=ru', {store_content_id => 'CAowkayeCQ', store_country => 'RU', os_type => 'Android', content_type => 'newsstand'}],
    # ['https://play.baidu.com/store/newsstand/details/Игромания?id=CAow8K2eCQ&hl=tr', undef],
    # ['https://play.google.com/store/newsstand/details/?id=&hl=tr', undef],

    # Apple App Store
    # Apps
    ['"https://itunes.apple.com/us/app/garageband/id408709785"', {store_content_id => 'id408709785', store_country => 'US', os_type => 'iOS', content_type => 'app', is_default_country => 0}],
    ['https://itunes.apple.com/us/app/garageband/id408709785?mt=8', {store_content_id => 'id408709785', store_country => 'US', os_type => 'iOS', content_type => 'app', is_default_country => 0}],
    ['https://itunes.apple.com/app/garageband/id408709785', {store_content_id => 'id408709785', store_country => 'RU', os_type => 'iOS', content_type => 'app', is_default_country => 1}],
    ['https://itunes.apple.com/app/id408709785', {store_content_id => 'id408709785', store_country => 'RU', os_type => 'iOS', content_type => 'app', is_default_country => 1}],
    ['http://itunes.apple.com/ru/app/garageband/id408709785', {store_content_id => 'id408709785', store_country => 'RU', os_type => 'iOS', content_type => 'app', is_default_country => 0}],
    ['itunes.apple.com/tr/app/garageband/id408709785?l=ru', {store_content_id => 'id408709785', store_country => 'TR', os_type => 'iOS', content_type => 'app', is_default_country => 0}],
    ['https://itunes.apple.com/en/app/world-of-tanks-blitz/id859204347', {store_content_id => 'id859204347', store_country => 'US', os_type => 'iOS', content_type => 'app', is_default_country => 0}],
    # ссылку с двумя или более слэшами считаем валидной
    ['itunes.apple.com//tr/app/garageband/id408709785?l=ru', {store_content_id => 'id408709785', store_country => 'TR', os_type => 'iOS', content_type => 'app', is_default_country => 0}],
    ['itunes.apple.com//app/garageband/id408709785?l=ru', {store_content_id => 'id408709785', store_country => 'RU', os_type => 'iOS', content_type => 'app', is_default_country => 1}],
    ['itunes.apple.com////////////rs/app/ga/id408709785?l=ru', {store_content_id => 'id408709785', store_country => 'RS', os_type => 'iOS', content_type => 'app', is_default_country => 0}],
    # страна большими буквами
    ['itunes.apple.com/TR/app/garageband/id408709785?l=ru', {store_content_id => 'id408709785', store_country => 'TR', os_type => 'iOS', content_type => 'app', is_default_country => 0}],
    # страна буквами разного регистра
    ['itunes.apple.com/Tr/app/garageband/id408709785?l=ru', {store_content_id => 'id408709785', store_country => 'TR', os_type => 'iOS', content_type => 'app', is_default_country => 0}],
    ['https://itunes.apple.com/pk/app/panda-parachute-rescue-fall/id689245528?mt=11&foo=baz&hl=tr&param=blah', {store_content_id => 'id689245528', store_country => 'PK', os_type => 'iOS', content_type => 'app', is_default_country => 0}],
    ['https://itunes.apple.com/ru/app/ex/id1052945328?mt=8', {store_content_id => 'id1052945328', store_country => 'RU', os_type => 'iOS', content_type => 'app', is_default_country => 0}],
    ['https://itunes.xiaomi.com/tr/app/garageband/id408709785?l=ru', undef],
    ['https://itunes.apple.com/tr/app/garageband', undef],
    # Пока поддерживаем только приложения, остальные типы контента недоступны
    ['https://itunes.apple.com/ru/movie/otel-grand-budapest/id832985900?l=ru', undef],
    ['https://itunes.apple.com/us/album/bullet-single/id986872941', undef],
    ['https://itunes.apple.com/tr/book/idle-thoughts-idle-fellow/id498917318?mt=11', undef],
    ['https://itunes.apple.com/us/podcast/military-hd/id289484726?mt=2', undef],
    # # Films
    # ['https://itunes.apple.com/ru/movie/otel-grand-budapest/id832985900?l=ru', {store_content_id => 'id832985900', store_country => 'RU', os_type => 'iOS', content_type => 'movie'}],
    # ['http://itunes.apple.com/ru/movie/1+1/id849916732', {store_content_id => 'id849916732', store_country => 'RU', os_type => 'iOS', content_type => 'movie'}],
    # ['itunes.apple.com/ru/movie/1+1/id849916732?l=uk', {store_content_id => 'id849916732', store_country => 'RU', os_type => 'iOS', content_type => 'movie'}],
    # ['https://itunes.apple.com/tr/movie/i-**-ali/id917209462?mt=11&foo=baz&hl=tr&param=blah', {store_content_id => 'id917209462', store_country => 'TR', os_type => 'iOS', content_type => 'movie'}],
    # ['https://itunes.xiaomi.com/tr/movie/garageband/id917209462?l=ru', undef],
    # ['https://itunes.apple.com/tr/movie/garageband', undef],
    # # Music
    # ['https://itunes.apple.com/us/album/bullet-single/id986872941', {store_content_id => 'id986872941', store_country => 'US', os_type => 'iOS', content_type => 'music'}],
    # ['http://itunes.apple.com/ru/album/lopside/id81974121?l=uk', {store_content_id => 'id81974121', store_country => 'RU', os_type => 'iOS', content_type => 'music'}],
    # ['itunes.apple.com/ru/album/around-rudimental-remix-edit/id558793046?i=558793339', {store_content_id => 'id558793046', store_country => 'RU', os_type => 'iOS', content_type => 'music'}],
    # ['https://itunes.apple.com/tr/album/made-pussy-single/id961670563?mt=11&foo=baz&hl=tr&param=blah', {store_content_id => 'id961670563', store_country => 'TR', os_type => 'iOS', content_type => 'music'}],
    # ['https://itunes.xiaomi.com/tr/album/lopside/id81974121?l=ru', undef],
    # ['https://itunes.apple.com/tr/album/lopside', undef],
    # # Books
    # ['https://itunes.apple.com/tr/book/idle-thoughts-idle-fellow/id498917318?mt=11', {store_content_id => 'id498917318', store_country => 'TR', os_type => 'iOS', content_type => 'book'}],
    # ['http://itunes.apple.com/ru/book/the-bertrams/id510921065?mt=11', {store_content_id => 'id510921065', store_country => 'RU', os_type => 'iOS', content_type => 'book'}],
    # ['itunes.apple.com/ru/book/preface-to-dictionary-english/id500615998?mt=11', {store_content_id => 'id500615998', store_country => 'RU', os_type => 'iOS', content_type => 'book'}],
    # ['https://itunes.apple.com/us/book/preface-to-dictionary-english/id500615998?mt=11&foo=baz&hl=tr&param=blah', {store_content_id => 'id500615998', store_country => 'US', os_type => 'iOS', content_type => 'book'}],
    # ['https://itunes.xiaomi.com/tr/book/the-bertrams/id510921065?l=ru', undef],
    # ['https://itunes.apple.com/tr/book/the-bertrams', undef],
    # # Podcast
    # ['https://itunes.apple.com/us/podcast/military-hd/id289484726?mt=2', {store_content_id => 'id289484726', store_country => 'US', os_type => 'iOS', content_type => 'podcast'}],
    # ['http://itunes.apple.com/ru/podcast/military-hd/id289484726?mt=2', {store_content_id => 'id289484726', store_country => 'RU', os_type => 'iOS', content_type => 'podcast'}],
    # ['itunes.apple.com/ru/podcast/military-hd/id289484726?mt=2', {store_content_id => 'id289484726', store_country => 'RU', os_type => 'iOS', content_type => 'podcast'}],
    # ['https://itunes.xiaomi.com/tr/podcast/military-hd/id289484726?l=ru', undef],
    # ['https://itunes.apple.com/tr/podcast/military-hd', undef],

    # Странные случаи
    [undef, undef],
    ['foo bar', undef],
    ['?mt=11&foo=baz&hl=tr&param=blah', undef],
    ['https%3A%2F%2Fplay.google.com%2Fstore%2Fapps%2Fdetails%3Fid%3Dcom.halfbrick.fruitninjafree%26foo%3Dbaz%26hl%3Dtr%26param%3Dblah', undef],
);

Test::More::plan(tests => scalar(@tests));

for my $test (@tests) {
    my ($input, $expected_out, $test_name) = @$test;
    $test_name ||= 'parse_store_url(' . ($input // 'undef') . ") = ".( to_json($expected_out // {}) // 'undef');
    is_deeply(Yandex::CheckMobileRedirect::parse_store_url($input), $expected_out, $test_name);
}
