#!/usr/bin/perl -w

=pod
    $Id$
=cut

use strict;
use Yandex::Test::UTF8Builder;
use Test::More;
use Test::Deep;

BEGIN { use_ok("Yandex::MyGoodWords"); }
sub ggw {
	return join ' ', @{(Yandex::MyGoodWords::MyGetGoodWords($_[0]))[0]};
}
sub o {
    return [Yandex::MyGoodWords::MyGetGoodWords(@_)];
}

use utf8;
use open ':std' => ':utf8';

is(ggw("Москву"), "москва", "simple");
is(ggw("\"Москву\""), "москва", "ignore quotes");
# раньше нормализация слова "двери" давала две формы двери и дверь
is(ggw("двери"), "дверь", "two norm forms");
is(ggw("двери москвой дверь"), "дверь москва", "skip repeates");
is(ggw("в дверь"), "дверь", "skip stop-words");
is(ggw("дверь -пиву"), "дверь", "skip minus");
is(ggw("!в дверь"), "дверь", "skip excl-stop-word");

is(ggw("костюм для танца живота"), "костюм танец живот", "stop words with many lemmas");

is(ggw("Санкт-Петербург"), "санкт-петербург", "defis");
is(ggw("хочу-немогу"), "хочу-немогать", "defis2");
is(ggw("10.2"), "10.2", "dot");
is(ggw("Я.Директ"), "директ директа", "dot2");

# DIRECT-11678
is(ggw('Межкомнатные двери.Екатеринбург'), 'межкомнатный дверь екатеринбург', 'phrase with dot inside word');
is(ggw('Межкомнатные двери'), 'межкомнатный дверь', 'normal phrase');

is(ggw('[Москва-Рим]'), 'москва-рим', 'фраза с оператором "фиксированный порядок слов"');

# регистр не влияет на формы
# в примерах смешаны русские и английские буквы
cmp_deeply(o("ОКНА"), o("окна"));
cmp_deeply(o("OKHа"), o("okhа"));

# слова со смешанным языком не нормализуются
isnt(ggw("окно"), ggw("оkна"));
is(ggw("оkна"), "оkна");
is(ggw("ОKНА"), "оkна");

done_testing;
