#!/usr/bin/perl -w

=pod
    $Id$
=cut

use strict;
use Yandex::Test::UTF8Builder;
use Test::Deep;
use Test::More;

BEGIN { use_ok("Yandex::MyGoodWords"); }
*_nw = \&Yandex::MyGoodWords::_norm_words;

use utf8;
use open ':std' => ':utf8';

cmp_deeply(_nw(""), undef, q/пустая строка/);
cmp_deeply(_nw(q/""/), undef, q/"" (две кавычки)/);
cmp_deeply(_nw(q/[]/), undef, q/[]/);
cmp_deeply(_nw(q/[!]/), undef, q/[!]/);
cmp_deeply(_nw("0"), [["0", "0"]], q/0 (ноль)/);

cmp_deeply(_nw("qwe"), [["qwe", "qwe"]], "test");
cmp_deeply(_nw("qwe -asdf -sfdg"), [["qwe", "qwe"]], "test");
cmp_deeply(_nw("qwe !jkgh -asdf -sfdg"), [["qwe", "qwe"], ["!jkgh", "!jkgh"]], "test");

cmp_deeply(_nw("qwe !меня -asdf -sfdg"), [["qwe", "qwe"], ["!меня", "!меня"]], "test");
cmp_deeply(_nw("qwe +jkgh -asdf -sfdg"), [["qwe", "qwe"], ["jkgh", "jkgh"]], "test");
cmp_deeply(_nw("qwe +меня -asdf -sfdg"), [["qwe", "qwe"], ["+меня", "+меня"]], "test");
cmp_deeply(_nw("qwe +я -asdf -sfdg"), [["qwe", "qwe"], ["+я", "+я"]], "test");

cmp_deeply(_nw("qwe -asdf -!sfdg"), [["qwe", "qwe"]], "test");

# DIRECT-11678
cmp_deeply(_nw('Межкомнатные двери.Екатеринбург'), [ ['Межкомнатные', 'межкомнатный'], ['двери', 'дверь'], ['Екатеринбург', 'екатеринбург'] ], 'phrase with dot inside word');
cmp_deeply(_nw('Межкомнатные двери'), [ ['Межкомнатные', 'межкомнатный'], ['двери', 'дверь'] ], 'normal phrase');

# DIRECT-13732
cmp_deeply(_nw('покупка [билета в питер]'), [["покупка","покупка"],["[билета","билет"],["в","в"],["питер]","питер"]], 'phrase with []');
cmp_deeply(_nw('[купить билет в питер]'), [["[купить","купить"],["билет","билет"],["в","в"],["питер]","питер"]], 'phrase with []');
cmp_deeply(_nw('[билет в питер][купить дешево]'), [["[билет","билет"],["в","в"],["питер","питер"],["купить","купить"],["дешево]","дешево"]], 'phrase with []');
cmp_deeply(_nw('[купить авиабилеты Москва-Берлин]'), [["[купить","купить"],["авиабилеты","авиабилет"],["Москва","москва"],["Берлин]","берлин"]], 'phrase with []');

cmp_deeply(_nw('[Москва-Рим]'), [['[Москва', 'москва'],['Рим]', 'рим']], '[Москва-Рим]');
cmp_deeply(_nw('[Москва-Рим].'), [['[Москва', 'москва'],['Рим]', 'рим']], '[Москва-Рим].');

#DIRECT-43006
cmp_deeply(_nw('как похудеть'), [['как', ''],['похудеть', 'похудеть']], 'stopword at the beginning');
cmp_deeply(_nw('"как похудеть"', undef, undef, undef, 1), [['как', 'как'],['похудеть', 'похудеть']], 'stopword at the beginning in quotes');

#DIRECT-127500
cmp_deeply(_nw('Гусеница Т-20.01 2001-22-1-06СБ'), [['Гусеница', 'гусеница'],['Т', 'т'],['20.01', '20.01'],['2001', '2001'],['22', '22'],['1', '1'],['06СБ', '06сб']], 'phrase with dot after -');
cmp_deeply(_nw('скачать майнкрафт 1.11.2'), [['скачать', 'скачать'], ['майнкрафт', 'майнкрафт'], ['1.11', '1.11'], ['2', '2']], 'phrase with two dots in word');
cmp_deeply(_nw('ст люсе SL657.101.01'), [['ст', 'ст'], ['люсе', 'люся'], ['SL', 'sl'], ['657.101', '657.101'], ['01', '01']], 'phrase with two dots in word');
cmp_deeply(_nw('1.2.3.4.5'), [['1.2', '1.2'], ['3.4', '3.4'], ['5', '5']], 'word with four dots');

done_testing();
