#!/usr/bin/perl

=pod
    $Id$
=cut

use strict;
use warnings;

use Yandex::Test::UTF8Builder;
use Test::More;

BEGIN { use_ok('Yandex::MyGoodWords'); }
*nw = \&Yandex::MyGoodWords::norm_words;

use utf8;

is(nw('купить билет [Москва Санкт-Петербург плацкарт] дёшево'), '[москва санкт петербург плацкарта] билет дешево купить');
is(nw('[Москва-Рим]'), '[москва рим]');
is(nw('[xxx].'), '[xxx]');
is(nw('"[!сауны в !москве]"'), '"[!сауны в !москве]"');
is(nw('[ханты мансийск екатеринбург]-москва -пермь -тюмень -сургут -туроператор -тур'),
    '[ханты мансийск екатеринбург]');
is(nw('0'), '0');

# DIRECT-38795
is(nw('куплю'), 'купить');

# оставляем минус-слова
is(nw("стулья -столы", 1), '-стол стул');
is(nw("1 2 3 4 5 -aaa -bbb -ccc -ddd", 1), '-aaa -bbb -ccc -ddd 1 2 3 4 5', 'много минус-слов');
is(nw("1 2 3 4 5 6 7 8 9 -aaa -bbb", 1), '-aaa -bbb 1 2 3 4 5 6 7', 'много слов и минус-слова');

done_testing();
