#!/usr/bin/perl

# $Id$

use strict;
use warnings;

use Test::More;
use Test::Deep;
use Test::Exception;

use YAML;

use my_inc::Layout;

my @valid_cases= (
    {
        name => 'single block',
        yaml => 
"---
blocks:
  - path: perl/rbac-elementary
    includes: []
",
        blocks => [
            {
                path => 'perl/rbac-elementary',
                includes => [],
            },
        ],
    },
    {
        name => 'dependencies 1',
        yaml => 
"---
blocks:
  - path: path_0
    includes: []
  - path: path_1
    includes: 
      - path_0
",
        blocks => [
            {
                path => 'path_0',
                includes => [],
            },
            {
                path => 'path_1',
                includes => [
                    'path_0',
                ],
            },
        ],
    },
);


my @invalid_cases = (
    {
        name => 'recursive dependencies-1',
        yaml => 
"---
blocks:
  - path: path_0
    includes: 
     - path_0 
  - path: path_1
    includes: 
     - path_0 
",
    },
    {
        name => 'recursive dependencies-2',
        yaml => 
"---
blocks:
  - path: path_0
    includes: 
     - path_1 
  - path: path_1
    includes: 
     - path_0 
",
    },
);


plan tests => scalar(@valid_cases) + scalar (@invalid_cases);


for my $c (@valid_cases){
    my $layout = YAML::Load($c->{yaml});
    my_inc::Layout::normalize_blocks($layout->{blocks});
    cmp_deeply($layout->{blocks}, $c->{blocks}, $c->{case});
}


for my $c (@invalid_cases){
    my $layout = YAML::Load($c->{yaml});
    dies_ok {
        my_inc::Layout::normalize_blocks($layout->{blocks});
    } $c->{name};
}


done_testing();

