package Yandex::Parallel;

=pod
    $Id$
    Модуль для распараллеливания процесса
=cut

use strict;
use warnings;

use POSIX ":sys_wait_h";

require Exporter;
our @ISA = qw/Exporter/;
our @EXPORT = qw/
        parallelize
        /;

# нужно ли прекращать respawn
our $FIN;

sub parallelize {
    my ($par_num, $opt) = @_;
    my (%PIDS, @processes);

    my $respawn_timeout = defined $opt->{respawn_timeout} ? $opt->{respawn_timeout} : 60;

    $FIN = 0;
    local $SIG{TERM} = sub { $FIN = 1; kill TERM => grep {$_} @processes };
    local $SIG{INT} = sub { $FIN = 1; kill INT => grep {$_} @processes };

    my $start_all = sub {
        for my $par_id ( 0 .. $par_num-1 ) {
            next if $processes[$par_id];
            my $pid = fork();
            if (!defined $pid) {
                # ошибка
                $processes[$par_id] = undef;
                die "Can't fork: $!";
            } elsif (!$pid) {
                # это сын. сыну надо работать!
                $0 = "child $par_id/$par_num: $0";
                return $par_id;
            } else {
                # а отец отдыхает
                $PIDS{$pid} = $par_id;
                $processes[$par_id] = $pid;
            }
        }
        return undef;
    };
    # Запускаем всех детей
    my $par_id = $start_all->();
    return $par_id if defined $par_id;
    # ждём пока кто-нибудь не сдохнет
    while( keys %PIDS) {
        sleep 1;
        while( (my $pid = waitpid(-1, WNOHANG)) > 0 ) {
            $processes[ $PIDS{$pid} ] = undef;
            delete $PIDS{$pid};
        }
        if ($opt->{respawn} && !$FIN) {
            sleep($respawn_timeout) if $respawn_timeout;
            my $par_id = $start_all->();
            return $par_id if defined $par_id;
        }
        if (ref $opt->{on_iteration} eq 'CODE') {
            $opt->{on_iteration}->();
        }
    }
    if ($opt->{father_return}) {
        return undef;
    } else {
        exit 0;
    }
}

1;
